/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public abstract class PortableStorageInterfaceBlockEntity
extends SmartBlockEntity {
    public static final int ANIMATION = 4;
    protected int transferTimer = 0;
    protected float distance;
    protected LerpedFloat connectionAnimation = LerpedFloat.linear().startWithValue(0.0);
    protected boolean powered = false;
    protected class_1297 connectedEntity;
    public int keepAlive = 0;

    public PortableStorageInterfaceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void startTransferringTo(Contraption contraption, float distance) {
        if (this.connectedEntity == contraption.entity) {
            return;
        }
        this.distance = Math.min(2.0f, distance);
        this.connectedEntity = contraption.entity;
        this.startConnecting();
        this.notifyUpdate();
    }

    protected void stopTransferring() {
        this.connectedEntity = null;
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204(), null);
    }

    public boolean canTransfer() {
        if (this.connectedEntity != null && !this.connectedEntity.method_5805()) {
            this.stopTransferring();
        }
        return this.connectedEntity != null && this.isConnected();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.powered = this.field_11863.method_49803(this.field_11867);
        if (!this.powered) {
            this.notifyContraptions();
        }
    }

    @Override
    public void tick() {
        boolean isConnected;
        boolean timerCanDecrement;
        super.tick();
        boolean wasConnected = this.isConnected();
        int timeUnit = this.getTransferTimeout();
        int animation = 4;
        if (this.keepAlive > 0) {
            --this.keepAlive;
            if (this.keepAlive == 0 && !this.field_11863.method_8608()) {
                this.stopTransferring();
                this.transferTimer = 3;
                this.sendData();
                return;
            }
        }
        this.transferTimer = Math.min(this.transferTimer, 8 + timeUnit);
        boolean bl = timerCanDecrement = this.transferTimer > 4 || this.transferTimer > 0 && this.keepAlive == 0 && (this.isVirtual() || !this.field_11863.method_8608() || this.transferTimer != 4);
        if (timerCanDecrement && (!this.isVirtual() || this.transferTimer != 4)) {
            --this.transferTimer;
            if (this.transferTimer == 3) {
                this.sendData();
            }
            if (this.transferTimer <= 0 || this.powered) {
                this.stopTransferring();
            }
        }
        if (wasConnected != (isConnected = this.isConnected()) && !this.field_11863.method_8608()) {
            this.method_5431();
        }
        float progress = 0.0f;
        if (isConnected) {
            progress = 1.0f;
        } else if (this.transferTimer >= timeUnit + animation) {
            progress = class_3532.method_48781((float)((float)(this.transferTimer - timeUnit - animation) / (float)animation), (int)1, (int)0);
        } else if (this.transferTimer < animation) {
            progress = class_3532.method_48781((float)((float)this.transferTimer / (float)animation), (int)0, (int)1);
        }
        this.connectionAnimation.setValue(progress);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.transferTimer = view.method_71424("Timer", 0);
        this.distance = view.method_71423("Distance", 0.0f);
        boolean poweredPreviously = this.powered;
        this.powered = view.method_71433("Powered", false);
        if (clientPacket && this.powered != poweredPreviously && !this.powered) {
            this.notifyContraptions();
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("Timer", this.transferTimer);
        view.method_71464("Distance", this.distance);
        view.method_71472("Powered", this.powered);
    }

    public void neighbourChanged() {
        boolean isBlockPowered = this.field_11863.method_49803(this.field_11867);
        if (isBlockPowered == this.powered) {
            return;
        }
        this.powered = isBlockPowered;
        if (!this.powered) {
            this.notifyContraptions();
        }
        if (this.powered) {
            this.stopTransferring();
        }
        this.sendData();
    }

    private void notifyContraptions() {
        this.field_11863.method_18467(AbstractContraptionEntity.class, new class_238(this.field_11867).method_1014(3.0)).forEach(AbstractContraptionEntity::refreshPSIs);
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2.0);
    }

    public boolean isTransferring() {
        return this.transferTimer > 4;
    }

    public boolean isConnected() {
        int timeUnit = this.getTransferTimeout();
        return this.transferTimer >= 4 && this.transferTimer <= timeUnit + 4;
    }

    public float getExtensionDistance(float partialTicks) {
        return (float)(Math.pow(this.connectionAnimation.getValue(partialTicks), 2.0) * (double)this.distance / 2.0);
    }

    float getConnectionDistance() {
        return this.distance;
    }

    public void startConnecting() {
        this.transferTimer = 14;
    }

    public void onContentTransferred() {
        int timeUnit = this.getTransferTimeout();
        this.transferTimer = timeUnit + 4;
        this.award(AllAdvancements.PSI);
        this.sendData();
    }

    protected Integer getTransferTimeout() {
        return (Integer)AllConfigs.server().logistics.psiTimeout.get();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PSI);
    }
}

