/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.elevator;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlock;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class ElevatorContactBlockEntity
extends SmartBlockEntity {
    public DoorControlBehaviour doorControls;
    public ElevatorColumn.ColumnCoords columnCoords;
    public boolean activateBlock;
    public String shortName = "";
    public String longName = "";
    public String lastReportedCurrentFloor = "";
    private int yTargetFromNBT = Integer.MIN_VALUE;
    private boolean deferNameGenerator = false;

    public ElevatorContactBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ELEVATOR_CONTACT, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.doorControls = new DoorControlBehaviour(this);
        behaviours.add(this.doorControls);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71469("ShortName", this.shortName);
        view.method_71469("LongName", this.longName);
        if (this.lastReportedCurrentFloor != null) {
            view.method_71469("LastReportedCurrentFloor", this.lastReportedCurrentFloor);
        }
        if (clientPacket) {
            return;
        }
        view.method_71472("Activate", this.activateBlock);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.get((class_1936)this.field_11863, this.columnCoords);
        if (column == null) {
            return;
        }
        view.method_71465("ColumnTarget", column.getTargetedYLevel());
        if (column.isActive()) {
            view.method_71472("ColumnActive", true);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.shortName = view.method_71428("ShortName", "");
        this.longName = view.method_71428("LongName", "");
        this.lastReportedCurrentFloor = view.method_71428("LastReportedCurrentFloor", null);
        if (clientPacket) {
            return;
        }
        this.activateBlock = view.method_71433("Activate", false);
        Optional columnTarget = view.method_71439("ColumnTarget");
        if (columnTarget.isEmpty()) {
            return;
        }
        int target = (Integer)columnTarget.get();
        boolean active = view.method_71433("ColumnActive", false);
        if (this.columnCoords == null) {
            this.yTargetFromNBT = target;
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((class_1936)this.field_11863, this.columnCoords);
        column.target(target);
        column.setActive(active);
    }

    public void updateDisplayedFloor(String floor) {
        if (floor.equals(this.lastReportedCurrentFloor)) {
            return;
        }
        this.lastReportedCurrentFloor = floor;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_11863.method_8608()) {
            return;
        }
        this.columnCoords = ElevatorContactBlock.getColumnCoords((class_1936)this.field_11863, this.field_11867);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((class_1936)this.field_11863, this.columnCoords);
        column.add(this.field_11867);
        if (this.shortName.isBlank()) {
            this.deferNameGenerator = true;
        }
        if (this.yTargetFromNBT == Integer.MIN_VALUE) {
            return;
        }
        column.target(this.yTargetFromNBT);
        this.yTargetFromNBT = Integer.MIN_VALUE;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.deferNameGenerator) {
            return;
        }
        if (this.columnCoords != null) {
            ElevatorColumn.getOrCreate((class_1936)this.field_11863, this.columnCoords).initNames(this.field_11863);
        }
        this.deferNameGenerator = false;
    }

    @Override
    public void invalidate() {
        ElevatorColumn column;
        if (this.columnCoords != null && (column = ElevatorColumn.get((class_1936)this.field_11863, this.columnCoords)) != null) {
            column.remove(this.field_11867);
        }
        super.invalidate();
    }

    public void updateName(String shortName, String longName) {
        this.shortName = shortName;
        this.longName = longName;
        this.deferNameGenerator = false;
        this.notifyUpdate();
        ElevatorColumn column = ElevatorColumn.get((class_1936)this.field_11863, this.columnCoords);
        if (column != null) {
            column.namesChanged();
        }
    }

    public Couple<String> getNames() {
        return Couple.create(this.shortName, this.longName);
    }
}

