/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class CouplingHandler {
    public static boolean preventEntitiesFromMoutingOccupiedCart(class_1297 entityMounting, class_1297 entityBeingMounted) {
        class_1688 cart;
        Optional<MinecartController> value;
        if (entityBeingMounted instanceof class_1688 && (value = AllSynchedDatas.MINECART_CONTROLLER.get((class_1297)(cart = (class_1688)entityBeingMounted))).isPresent()) {
            return !(entityMounting instanceof AbstractContraptionEntity) && value.get().isCoupledThroughContraption();
        }
        return false;
    }

    public static void forEachLoadedCoupling(class_1937 world, Consumer<Couple<MinecartController>> consumer) {
        if (world == null) {
            return;
        }
        Set<UUID> cartsWithCoupling = CapabilityMinecartController.loadedMinecartsWithCoupling.get((class_1936)world);
        if (cartsWithCoupling == null) {
            return;
        }
        for (UUID id : cartsWithCoupling) {
            MinecartController controller = CapabilityMinecartController.getIfPresent(world, id);
            if (controller == null) {
                return;
            }
            if (!controller.isLeadingCoupling()) {
                return;
            }
            UUID coupledCart = controller.getCoupledCart(true);
            MinecartController coupledController = CapabilityMinecartController.getIfPresent(world, coupledCart);
            if (coupledController == null) {
                return;
            }
            consumer.accept(Couple.create(controller, coupledController));
        }
    }

    public static boolean tryToCoupleCarts(@Nullable class_1657 player, class_1937 world, int cartId1, int cartId2) {
        boolean contraptionCoupling;
        class_1297 entity1 = world.method_8469(cartId1);
        class_1297 entity2 = world.method_8469(cartId2);
        if (!(entity1 instanceof class_1688)) {
            return false;
        }
        class_1688 cart1 = (class_1688)entity1;
        if (!(entity2 instanceof class_1688)) {
            return false;
        }
        class_1688 cart2 = (class_1688)entity2;
        String tooMany = "two_couplings_max";
        String unloaded = "unloaded";
        String noLoops = "no_loops";
        String tooFar = "too_far";
        int distanceTo = (int)entity1.method_73189().method_1022(entity2.method_73189());
        boolean bl = contraptionCoupling = player == null;
        if (distanceTo < 2) {
            if (contraptionCoupling) {
                return false;
            }
            distanceTo = 2;
        }
        if (distanceTo > (Integer)AllConfigs.server().kinetics.maxCartCouplingLength.get()) {
            CouplingHandler.status(player, tooFar);
            return false;
        }
        UUID mainID = cart1.method_5667();
        UUID connectedID = cart2.method_5667();
        MinecartController mainController = CapabilityMinecartController.getIfPresent(world, mainID);
        MinecartController connectedController = CapabilityMinecartController.getIfPresent(world, connectedID);
        if (mainController == null || connectedController == null) {
            CouplingHandler.status(player, unloaded);
            return false;
        }
        if (mainController.isFullyCoupled() || connectedController.isFullyCoupled()) {
            CouplingHandler.status(player, tooMany);
            return false;
        }
        if (mainController.isLeadingCoupling() && mainController.getCoupledCart(true).equals(connectedID) || connectedController.isLeadingCoupling() && connectedController.getCoupledCart(true).equals(mainID)) {
            return false;
        }
        block0: for (boolean main : Iterate.trueAndFalse) {
            Optional<MinecartController> next;
            MinecartController current = main ? mainController : connectedController;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            do {
                if (safetyCount-- <= 0) {
                    Create.LOGGER.warn("Infinite loop in coupling iteration");
                    return false;
                }
                next = CouplingHandler.getNextInCouplingChainLegacy(world, current, forward);
                if (next == null) {
                    CouplingHandler.status(player, unloaded);
                    return false;
                }
                if (next.isEmpty()) continue block0;
            } while ((current = next.get()) != connectedController);
            CouplingHandler.status(player, noLoops);
            return false;
        }
        if (!contraptionCoupling) {
            for (class_1268 hand : class_1268.values()) {
                if (player.method_68878()) break;
                class_1799 heldItem = player.method_5998(hand);
                if (!heldItem.method_31574((class_1792)AllItems.MINECART_COUPLING)) continue;
                heldItem.method_7934(1);
                break;
            }
        }
        mainController.prepareForCoupling(true);
        connectedController.prepareForCoupling(false);
        mainController.coupleWith(true, connectedID, distanceTo, contraptionCoupling);
        connectedController.coupleWith(false, mainID, distanceTo, contraptionCoupling);
        return true;
    }

    @Nullable
    public static Optional<MinecartController> getNextInCouplingChainLegacy(class_1937 world, MinecartController controller, boolean forward) {
        UUID coupledCart = controller.getCoupledCart(forward);
        if (coupledCart == null) {
            return Optional.empty();
        }
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(world, coupledCart);
        return coupledController == null ? null : Optional.of(coupledController);
    }

    public static Optional<MinecartController> getNextInCouplingChain(class_1937 world, MinecartController controller, boolean forward) {
        UUID coupledCart = controller.getCoupledCart(forward);
        if (coupledCart == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(CapabilityMinecartController.getIfPresent(world, coupledCart));
    }

    public static void status(class_1657 player, String key) {
        if (player == null) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)("create.minecart_coupling." + key)), true);
    }
}

