/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1695;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class MinecartController {
    public static final Codec<MinecartController> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Couple.optionalCodec(StallData.CODEC).fieldOf("stallData").forGetter(i -> i.stallData), (App)Couple.optionalCodec(CouplingData.CODEC).fieldOf("couplings").forGetter(i -> i.couplings)).apply((Applicative)instance, MinecartController::new));
    public static final class_9139<class_9129, MinecartController> PACKET_CODEC = class_9139.method_56435(Couple.streamCodec(StallData.PACKET_CODEC.method_56433(class_9135::method_56382)), i -> i.stallData, Couple.streamCodec(CouplingData.PACKET_CODEC.method_56433(class_9135::method_56382)), i -> i.couplings, MinecartController::new);
    private boolean needsEntryRefresh;
    private class_1688 cart;
    private Couple<Optional<StallData>> stallData;
    private Couple<Optional<CouplingData>> couplings;

    public MinecartController(class_1688 minecart) {
        this.cart = minecart;
        this.stallData = Couple.create(Optional::empty);
        this.couplings = Couple.create(Optional::empty);
        this.needsEntryRefresh = true;
    }

    private MinecartController(Couple<Optional<StallData>> stallData, Couple<Optional<CouplingData>> couplings) {
        this.stallData = stallData;
        this.couplings = couplings;
        this.needsEntryRefresh = true;
    }

    public class_1688 cart() {
        return this.cart;
    }

    public void coupleWith(boolean isLeading, UUID coupled, float length, boolean contraption) {
        UUID mainID = isLeading ? this.cart().method_5667() : coupled;
        UUID connectedID = isLeading ? coupled : this.cart().method_5667();
        this.couplings.set(isLeading, Optional.of(new CouplingData(mainID, connectedID, length, contraption)));
        this.needsEntryRefresh |= isLeading;
        this.sendData();
    }

    public void decouple() {
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(this.cart.method_73183(), idOfOther);
            if (otherCart == null) {
                return;
            }
            this.removeConnection((boolean)main);
            otherCart.removeConnection(main == false);
        }));
    }

    private void disassemble(class_1688 cart) {
        class_2338 blockpos;
        class_2680 blockstate;
        int k;
        int j;
        int i;
        if (cart instanceof class_1695) {
            return;
        }
        List passengers = cart.method_5685();
        if (passengers.isEmpty() || !(passengers.getFirst() instanceof AbstractContraptionEntity)) {
            return;
        }
        class_1937 world = cart.method_73183();
        if (world.method_8320(new class_2338(i = class_3532.method_15357((double)cart.method_23317()), (j = class_3532.method_15357((double)cart.method_23318())) - 1, k = class_3532.method_15357((double)cart.method_23321()))).method_26164(class_3481.field_15463)) {
            --j;
        }
        if ((blockstate = world.method_8320(blockpos = new class_2338(i, j, k))).method_26164(class_3481.field_15463) && blockstate.method_26204() == class_2246.field_10546) {
            if (cart.method_5782()) {
                cart.method_5772();
            }
            if (cart.method_54295() == 0) {
                cart.method_54300(-cart.method_54296());
                cart.method_54299(10);
                cart.method_54297(50.0f);
                cart.field_6037 = true;
            }
        }
    }

    @Nullable
    public UUID getCoupledCart(boolean asMain) {
        Optional<CouplingData> optional = this.couplings.get(asMain);
        if (optional.isEmpty()) {
            return null;
        }
        CouplingData couplingData = optional.get();
        return asMain ? couplingData.connectedCartID : couplingData.mainCartID;
    }

    public float getCouplingLength(boolean leading) {
        Optional<CouplingData> optional = this.couplings.get(leading);
        return optional.map(couplingData -> Float.valueOf(couplingData.length)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean hasContraptionCoupling(boolean current) {
        Optional<CouplingData> optional = this.couplings.get(current);
        return optional.isPresent() && optional.get().contraption;
    }

    public boolean isConnectedToCoupling() {
        return this.couplings.get(false).isPresent();
    }

    public boolean isCoupledThroughContraption() {
        return this.couplings.stream().anyMatch(i -> i.map(CouplingData::getContraption).orElse(false));
    }

    public boolean isFullyCoupled() {
        return this.isLeadingCoupling() && this.isConnectedToCoupling();
    }

    public boolean isLeadingCoupling() {
        return this.couplings.get(true).isPresent();
    }

    public boolean isPresent() {
        return this.cart.method_5805();
    }

    public boolean isStalled() {
        return this.isStalled(true) || this.isStalled(false);
    }

    private boolean isStalled(boolean internal) {
        return this.stallData.get(internal).isPresent();
    }

    public void prepareForCoupling(boolean isLeading) {
        if (isLeading && this.isLeadingCoupling() || !isLeading && this.isConnectedToCoupling()) {
            Optional<MinecartController> next;
            ArrayList<MinecartController> cartsToFlip = new ArrayList<MinecartController>();
            cartsToFlip.add(this);
            MinecartController current = this;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            class_1937 world = this.cart.method_73183();
            while (safetyCount-- > 0 && !(next = CouplingHandler.getNextInCouplingChain(world, current, forward)).isEmpty()) {
                current = next.get();
                cartsToFlip.add(current);
            }
            if (safetyCount == 0) {
                Create.LOGGER.warn("Infinite loop in coupling iteration");
                return;
            }
            for (MinecartController minecartController : cartsToFlip) {
                minecartController.couplings.forEachWithContext((opt, leading) -> opt.ifPresent(cd -> {
                    cd.flip();
                    if (!cd.contraption) {
                        return;
                    }
                    List passengers = minecartController.cart().method_5685();
                    if (passengers.isEmpty()) {
                        return;
                    }
                    class_1297 entity = (class_1297)passengers.getFirst();
                    if (!(entity instanceof OrientedContraptionEntity)) {
                        return;
                    }
                    OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
                    UUID couplingId = contraption.getCouplingId();
                    if (couplingId == cd.mainCartID) {
                        contraption.setCouplingId(cd.connectedCartID);
                        return;
                    }
                    if (couplingId == cd.connectedCartID) {
                        contraption.setCouplingId(cd.mainCartID);
                    }
                }));
                minecartController.couplings = minecartController.couplings.swap();
                minecartController.needsEntryRefresh = true;
                if (minecartController == this) continue;
                minecartController.sendData();
            }
        }
    }

    public void removeConnection(boolean main) {
        class_1297 entity;
        List passengers;
        class_1937 world;
        if (this.hasContraptionCoupling(main) && (world = this.cart.method_73183()) != null && !world.method_8608() && !(passengers = this.cart().method_5685()).isEmpty() && (entity = (class_1297)passengers.getFirst()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)entity;
            abstractContraptionEntity.disassemble();
        }
        this.couplings.set(main, Optional.empty());
        this.needsEntryRefresh |= main;
        this.sendData();
    }

    public void sendData() {
        this.sendData(null);
    }

    public void sendData(@Nullable class_1688 cart) {
        if (cart != null) {
            this.cart = cart;
            this.needsEntryRefresh = true;
        }
        if (this.cart.method_73183().method_8608()) {
            return;
        }
        AllSynchedDatas.MINECART_CONTROLLER.set((class_1297)this.cart, Optional.of(this), true);
    }

    public void setCart(class_1688 cart) {
        this.cart = cart;
    }

    private void setStalled(boolean stall, boolean internal) {
        if (this.isStalled(internal) == stall || this.cart == null) {
            return;
        }
        if (stall) {
            this.stallData.set(internal, Optional.of(new StallData(this.cart)));
            this.sendData();
            return;
        }
        if (!this.isStalled(!internal)) {
            this.stallData.get(internal).ifPresent(data -> data.release(this.cart));
        }
        this.stallData.set(internal, Optional.empty());
        this.sendData();
    }

    public void setStalledExternally(boolean stall) {
        this.setStalled(stall, false);
    }

    public void tick() {
        if (this.cart == null) {
            return;
        }
        class_1937 world = this.cart.method_73183();
        if (world == null) {
            return;
        }
        if (this.needsEntryRefresh) {
            CapabilityMinecartController.queuedAdditions.get((class_1936)world).add(this.cart);
            this.needsEntryRefresh = false;
        }
        this.stallData.forEach(opt -> opt.ifPresent(sd -> sd.tick(this.cart)));
        MutableBoolean internalStall = new MutableBoolean(false);
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(world, idOfOther);
            internalStall.setValue(internalStall.booleanValue() || otherCart == null || !otherCart.isPresent() || otherCart.isStalled(false));
        }));
        if (!world.method_8608()) {
            this.setStalled(internalStall.booleanValue(), true);
            this.disassemble(this.cart);
        }
    }

    private static class CouplingData {
        public static final Codec<CouplingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_40825.fieldOf("mainCartID").forGetter(i -> i.mainCartID), (App)class_4844.field_40825.fieldOf("connectedCartID").forGetter(i -> i.connectedCartID), (App)Codec.FLOAT.fieldOf("length").forGetter(i -> Float.valueOf(i.length)), (App)Codec.BOOL.fieldOf("contraption").forGetter(i -> i.contraption)).apply((Applicative)instance, CouplingData::new));
        public static final class_9139<class_9129, CouplingData> PACKET_CODEC = class_9139.method_56905((class_9139)class_4844.field_48453, i -> i.mainCartID, (class_9139)class_4844.field_48453, i -> i.connectedCartID, (class_9139)class_9135.field_48552, i -> Float.valueOf(i.length), (class_9139)class_9135.field_48547, i -> i.contraption, CouplingData::new);
        private final float length;
        private final boolean contraption;
        private UUID mainCartID;
        private UUID connectedCartID;

        public CouplingData(UUID mainCartID, UUID connectedCartID, float length, boolean contraption) {
            this.mainCartID = mainCartID;
            this.connectedCartID = connectedCartID;
            this.length = length;
            this.contraption = contraption;
        }

        public void flip() {
            UUID swap = this.mainCartID;
            this.mainCartID = this.connectedCartID;
            this.connectedCartID = swap;
        }

        public boolean getContraption() {
            return this.contraption;
        }

        public UUID idOfCart(boolean main) {
            return main ? this.mainCartID : this.connectedCartID;
        }
    }

    private record StallData(class_243 position, class_243 motion, float yaw, float pitch) {
        public static final Codec<StallData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_243.field_38277.fieldOf("position").forGetter(StallData::position), (App)class_243.field_38277.fieldOf("motion").forGetter(StallData::motion), (App)Codec.FLOAT.fieldOf("yaw").forGetter(StallData::yaw), (App)Codec.FLOAT.fieldOf("pitch").forGetter(StallData::pitch)).apply((Applicative)instance, StallData::new));
        public static final class_9139<class_9129, StallData> PACKET_CODEC = class_9139.method_56905((class_9139)class_243.field_52694, StallData::position, (class_9139)class_243.field_52694, StallData::motion, (class_9139)class_9135.field_48552, StallData::yaw, (class_9139)class_9135.field_48552, StallData::pitch, StallData::new);

        public StallData(class_1688 entity) {
            this(entity.method_73189(), entity.method_18798(), entity.method_36454(), entity.method_36455());
            this.tick(entity);
        }

        public void release(class_1688 entity) {
            entity.method_18799(this.motion);
        }

        public void tick(class_1688 entity) {
            entity.method_18799(class_243.field_1353);
            entity.method_36456(this.yaw);
            entity.method_36457(this.pitch);
        }
    }
}

