/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.steamWhistle;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class WhistleBlockEntity
extends SmartBlockEntity {
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public int pitch;

    public WhistleBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.STEAM_WHISTLE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_WHISTLE);
    }

    public void updatePitch() {
        class_2680 blockState;
        int newPitch;
        class_2338 currentPos = this.field_11867.method_10084();
        for (newPitch = 0; newPitch <= 24 && (blockState = this.field_11863.method_8320(currentPos)).method_27852((class_2248)AllBlocks.STEAM_WHISTLE_EXTENSION); newPitch += 2) {
            if (blockState.method_11654(WhistleExtenderBlock.SHAPE) == WhistleExtenderBlock.WhistleExtenderShape.SINGLE) {
                ++newPitch;
                break;
            }
            currentPos = currentPos.method_10084();
        }
        if (this.pitch == newPitch) {
            return;
        }
        this.pitch = newPitch;
        this.notifyUpdate();
        FluidTankBlockEntity tank = this.getTank();
        if (tank != null && tank.boiler != null) {
            tank.boiler.checkPipeOrganAdvancement(tank);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.method_8608() && this.isPowered()) {
            this.award(AllAdvancements.STEAM_WHISTLE);
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Pitch", this.pitch);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.pitch = view.method_71424("Pitch", 0);
        super.read(view, clientPacket);
    }

    public boolean isPowered() {
        return (Boolean)this.method_11010().method_61767((class_2769)WhistleBlock.POWERED, (Comparable)Boolean.valueOf(false));
    }

    public WhistleBlock.WhistleSize getOctave() {
        return (WhistleBlock.WhistleSize)((Object)this.method_11010().method_61767(WhistleBlock.SIZE, (Comparable)((Object)WhistleBlock.WhistleSize.MEDIUM)));
    }

    public int getPitchId() {
        return this.pitch + 100 * ((WhistleBlock.WhistleSize)((Object)this.method_11010().method_61767(WhistleBlock.SIZE, (Comparable)((Object)WhistleBlock.WhistleSize.MEDIUM)))).ordinal();
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.method_11015()) {
            class_2350 facing;
            class_2586 be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.field_11863.method_8321(this.field_11867.method_10093(facing = WhistleBlock.getAttachedDirection(this.method_11010())))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

