/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.drain;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.fluids.drain.ItemDrainItemHandler;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class ItemDrainBlockEntity
extends SmartBlockEntity {
    public static final int FILLING_TIME = 20;
    public SmartFluidTankBehaviour internalTank;
    public TransportedItemStack heldItem;
    public int processingTicks;
    public Map<class_2350, ItemDrainItemHandler> itemHandlers = new IdentityHashMap<class_2350, ItemDrainItemHandler>();

    public ItemDrainBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ITEM_DRAIN, pos, state);
        for (class_2350 d : Iterate.horizontalDirections) {
            this.itemHandlers.put(d, new ItemDrainItemHandler(this, d));
        }
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1799 heldItemStack = this.getHeldItemStack();
        if (!heldItemStack.method_7960()) {
            class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)heldItemStack);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = SmartFluidTankBehaviour.single(this, 121500, (TriFunction<SmartFluidTankBehaviour, Boolean, Optional<Integer>, SmartFluidTankBehaviour.InternalFluidHandler>)((TriFunction)ItemDrainFluidHandler::new)).allowExtraction().forbidInsertion();
        behaviours.add(this.internalTank);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.DRAIN, AllAdvancements.CHAINED_DRAIN);
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;
        class_1799 returned = class_1799.field_8037;
        if (!this.getHeldItemStack().method_7960()) {
            return inserted;
        }
        if (inserted.method_7947() > 1 && GenericItemEmptying.canItemBeEmptied(this.field_11863, inserted)) {
            returned = inserted.method_46651(inserted.method_7947() - 1);
            inserted = inserted.method_46651(1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.method_7972();
        transportedStack.beltPosition = side.method_10166().method_10178() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.method_5431();
        this.sendData();
        return returned;
    }

    public class_1799 getHeldItemStack() {
        return this.heldItem == null ? class_1799.field_8037 : this.heldItem.stack;
    }

    @Override
    public void tick() {
        boolean onClient;
        super.tick();
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        boolean bl = onClient = this.field_11863.method_8608() && !this.isVirtual();
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 20;
            if (!onClient || this.processingTicks < 20) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 20)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            class_2338 nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            class_2350 side = this.heldItem.insertedFrom;
            class_1799 tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(this.heldItem.stack, side.method_10153(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.method_7947() != this.heldItem.stack.method_7947()) {
                    if (tryExportingToBeltFunnel.method_7960()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.method_7960()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, nextPosition = this.field_11867.method_10093(side), DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide(this.field_11863.method_8320(nextPosition), (class_1922)this.field_11863, nextPosition, side.method_10153())) {
                    class_1799 ejected = this.heldItem.stack;
                    class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(class_243.method_24954((class_2382)side.method_62675()).method_1021(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    class_243 outMotion = class_243.method_24954((class_2382)side.method_62675()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
                    outPos.method_1019(outMotion.method_1029());
                    class_1542 entity = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
                    entity.method_18799(outMotion);
                    entity.method_6988();
                    entity.field_6037 = true;
                    this.field_11863.method_8649((class_1297)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            class_1799 returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.method_7960()) {
                if (this.field_11863.method_8321(nextPosition) instanceof ItemDrainBlockEntity) {
                    this.award(AllAdvancements.CHAINED_DRAIN);
                }
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.method_7947() != this.heldItem.stack.method_7947()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (!GenericItemEmptying.canItemBeEmptied(this.field_11863, this.heldItem.stack)) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 20;
            this.sendData();
        }
    }

    protected boolean continueProcessing() {
        if (this.field_11863.method_8608() && !this.isVirtual()) {
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        if (!GenericItemEmptying.canItemBeEmptied(this.field_11863, this.heldItem.stack)) {
            return false;
        }
        Pair<FluidStack, class_1799> emptyItem = GenericItemEmptying.emptyItem(this.field_11863, this.heldItem.stack, true);
        FluidStack fluidFromItem = emptyItem.getFirst();
        if (this.processingTicks > 5) {
            this.internalTank.allowInsertion();
            int amount = fluidFromItem.getAmount();
            if (this.internalTank.getPrimaryHandler().countSpace(fluidFromItem) != amount) {
                this.internalTank.forbidInsertion();
                this.processingTicks = 20;
                return true;
            }
            this.internalTank.forbidInsertion();
            return true;
        }
        emptyItem = GenericItemEmptying.emptyItem(this.field_11863, this.heldItem.stack.method_7972(), false);
        this.award(AllAdvancements.DRAIN);
        class_1799 out = emptyItem.getSecond();
        if (!out.method_7960()) {
            this.heldItem.stack = out;
        } else {
            this.heldItem = null;
        }
        this.internalTank.allowInsertion();
        this.internalTank.getPrimaryHandler().insert(fluidFromItem);
        this.internalTank.forbidInsertion();
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    public void setHeldItem(TransportedItemStack heldItem, class_2350 insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("ProcessingTicks", this.processingTicks);
        if (this.heldItem != null) {
            view.method_71468("HeldItem", TransportedItemStack.CODEC, (Object)this.heldItem);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.heldItem = null;
        this.processingTicks = view.method_71424("ProcessingTicks", 0);
        this.heldItem = view.method_71426("HeldItem", TransportedItemStack.CODEC).orElse(null);
        super.read(view, clientPacket);
    }

    public static class ItemDrainFluidHandler
    extends SmartFluidTankBehaviour.InternalFluidHandler {
        private static final int[] EMPTY_SLOTS = new int[0];

        public ItemDrainFluidHandler(SmartFluidTankBehaviour behaviour, boolean enforceVariety, Optional<Integer> max) {
            super(behaviour, enforceVariety, max);
        }

        @Override
        public int[] getAvailableSlots(@Nullable class_2350 side) {
            if (side == class_2350.field_11036) {
                return EMPTY_SLOTS;
            }
            return super.getAvailableSlots(side);
        }
    }
}

