/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.tank;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class SoundPool {
    private final int maxConcurrent;
    private final int mergeTicks;
    private final Sound sound;
    private final LongList queuedPositions = new LongArrayList();
    private final class_2338.class_2339 pos = new class_2338.class_2339();
    private int ticks = 0;

    public SoundPool(int maxConcurrent, int mergeTicks, Sound sound) {
        this.maxConcurrent = maxConcurrent;
        this.sound = sound;
        this.mergeTicks = mergeTicks;
    }

    public void queueAt(class_2338 pos) {
        this.queueAt(pos.method_10063());
    }

    public void queueAt(long pos) {
        this.queuedPositions.add(pos);
    }

    public void play(class_1937 level) {
        if (this.queuedPositions.isEmpty()) {
            return;
        }
        ++this.ticks;
        if (this.ticks < this.mergeTicks) {
            return;
        }
        this.ticks = 0;
        int numberOfPositions = this.queuedPositions.size();
        if (numberOfPositions <= this.maxConcurrent) {
            LongListIterator longListIterator = this.queuedPositions.iterator();
            while (longListIterator.hasNext()) {
                long pos = (Long)longListIterator.next();
                this.playAt(level, pos);
            }
        } else {
            while (!this.queuedPositions.isEmpty() && this.queuedPositions.size() > numberOfPositions - this.maxConcurrent) {
                this.rollNextPosition(level);
            }
        }
        this.queuedPositions.clear();
    }

    private void rollNextPosition(class_1937 level) {
        int index = level.field_9229.method_43048(this.queuedPositions.size());
        long pos = this.queuedPositions.removeLong(index);
        this.playAt(level, pos);
    }

    private void playAt(class_1937 level, long pos) {
        this.sound.playAt(level, (class_2382)this.pos.method_16363(pos));
    }

    public static interface Sound {
        public void playAt(class_1937 var1, class_2382 var2);
    }
}

