/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt.behaviour;

import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class DirectBeltInputBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<DirectBeltInputBehaviour> TYPE = new BehaviourType();
    private InsertionCallback tryInsert = this::defaultInsertionCallback;
    private OccupiedPredicate isOccupied;
    private AvailabilityPredicate canInsert = d -> true;
    private Supplier<Boolean> supportsBeltFunnels;

    public DirectBeltInputBehaviour(SmartBlockEntity be) {
        super(be);
        this.isOccupied = d -> false;
        this.supportsBeltFunnels = () -> false;
    }

    public DirectBeltInputBehaviour allowingBeltFunnelsWhen(Supplier<Boolean> pred) {
        this.supportsBeltFunnels = pred;
        return this;
    }

    public DirectBeltInputBehaviour allowingBeltFunnels() {
        this.supportsBeltFunnels = () -> true;
        return this;
    }

    public DirectBeltInputBehaviour onlyInsertWhen(AvailabilityPredicate pred) {
        this.canInsert = pred;
        return this;
    }

    public DirectBeltInputBehaviour considerOccupiedWhen(OccupiedPredicate pred) {
        this.isOccupied = pred;
        return this;
    }

    public DirectBeltInputBehaviour setInsertionHandler(InsertionCallback callback) {
        this.tryInsert = callback;
        return this;
    }

    private class_1799 defaultInsertionCallback(TransportedItemStack inserted, class_2350 side, boolean simulate) {
        class_1263 lazy = ItemHelper.getInventory(this.blockEntity.method_10997(), this.blockEntity.method_11016(), null, this.blockEntity, side);
        if (lazy == null) {
            return inserted.stack;
        }
        int count = inserted.stack.method_7947();
        int insert = simulate ? lazy.countSpace(inserted.stack, count, side) : lazy.insertExist(inserted.stack, side);
        if (insert == 0) {
            return inserted.stack;
        }
        if (insert == count) {
            return class_1799.field_8037;
        }
        return inserted.stack.method_46651(count - insert);
    }

    public boolean canInsertFromSide(class_2350 side) {
        return this.canInsert.test(side);
    }

    public boolean isOccupied(class_2350 side) {
        return this.isOccupied.test(side);
    }

    public class_1799 handleInsertion(class_1799 stack, class_2350 side, boolean simulate) {
        return this.handleInsertion(new TransportedItemStack(stack), side, simulate);
    }

    public class_1799 handleInsertion(TransportedItemStack stack, class_2350 side, boolean simulate) {
        return this.tryInsert.apply(stack, side, simulate);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Nullable
    public class_1799 tryExportingToBeltFunnel(class_1799 stack, @Nullable class_2350 side, boolean simulate) {
        class_2338 funnelPos = this.blockEntity.method_11016().method_10084();
        class_1937 world = this.getWorld();
        class_2680 funnelState = world.method_8320(funnelPos);
        if (!(funnelState.method_26204() instanceof BeltFunnelBlock)) {
            return null;
        }
        if (funnelState.method_11654(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.PULLING) {
            return null;
        }
        if (side != null && FunnelBlock.getFunnelFacing(funnelState) != side) {
            return null;
        }
        class_2586 be = world.method_8321(funnelPos);
        if (!(be instanceof FunnelBlockEntity)) {
            return null;
        }
        if (((Boolean)funnelState.method_11654((class_2769)BeltFunnelBlock.POWERED)).booleanValue()) {
            return null;
        }
        class_1799 insert = FunnelBlock.tryInsert(world, funnelPos, stack, simulate);
        if (insert.method_7947() != stack.method_7947() && !simulate) {
            ((FunnelBlockEntity)be).flap(true);
        }
        return insert;
    }

    public boolean canSupportBeltFunnels() {
        return this.supportsBeltFunnels.get();
    }

    @FunctionalInterface
    public static interface InsertionCallback {
        public class_1799 apply(TransportedItemStack var1, class_2350 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface AvailabilityPredicate {
        public boolean test(class_2350 var1);
    }

    @FunctionalInterface
    public static interface OccupiedPredicate {
        public boolean test(class_2350 var1);
    }
}

