/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt.transport;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.BeltCrusherInteractionHandler;
import com.zurrtum.create.content.kinetics.belt.transport.BeltFunnelInteractionHandler;
import com.zurrtum.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class BeltInventory {
    final BeltBlockEntity belt;
    private final List<TransportedItemStack> items;
    final List<TransportedItemStack> toInsert;
    final List<TransportedItemStack> toRemove;
    boolean beltMovementPositive;
    TransportedItemStack lazyClientItem;

    public BeltInventory(BeltBlockEntity be) {
        this.belt = be;
        this.items = new LinkedList<TransportedItemStack>();
        this.toInsert = new LinkedList<TransportedItemStack>();
        this.toRemove = new LinkedList<TransportedItemStack>();
    }

    public void tick() {
        if (this.lazyClientItem != null) {
            if (this.lazyClientItem.locked) {
                this.lazyClientItem = null;
            } else {
                this.lazyClientItem.locked = true;
            }
        }
        if (!this.toInsert.isEmpty() || !this.toRemove.isEmpty()) {
            this.toInsert.forEach(this::insert);
            this.toInsert.clear();
            this.items.removeAll(this.toRemove);
            this.toRemove.clear();
            this.belt.notifyUpdate();
        }
        if (this.belt.getSpeed() == 0.0f) {
            return;
        }
        if (this.beltMovementPositive != this.belt.getDirectionAwareBeltMovementSpeed() > 0.0f) {
            this.beltMovementPositive = !this.beltMovementPositive;
            Collections.reverse(this.items);
            this.belt.notifyUpdate();
        }
        TransportedItemStack stackInFront = null;
        TransportedItemStack currentItem = null;
        Iterator<TransportedItemStack> iterator = this.items.iterator();
        float beltSpeed = this.belt.getDirectionAwareBeltMovementSpeed();
        class_2350 movementFacing = this.belt.getMovementFacing();
        boolean horizontal = this.belt.method_11010().method_11654(BeltBlock.SLOPE) == BeltSlope.HORIZONTAL;
        float spacing = 1.0f;
        class_1937 world = this.belt.method_10997();
        boolean onClient = world.method_8608() && !this.belt.isVirtual();
        Ending ending = Ending.UNRESOLVED;
        while (iterator.hasNext()) {
            float diffToEnd;
            stackInFront = currentItem;
            currentItem = iterator.next();
            currentItem.prevBeltPosition = currentItem.beltPosition;
            currentItem.prevSideOffset = currentItem.sideOffset;
            if (currentItem.stack.method_7960()) {
                iterator.remove();
                currentItem = null;
                continue;
            }
            float movement = beltSpeed;
            if (onClient) {
                movement *= AllClientHandle.INSTANCE.getServerSpeed();
            }
            if (world.method_8608() && currentItem.locked) continue;
            if (currentItem.lockedExternally) {
                currentItem.lockedExternally = false;
                continue;
            }
            boolean noMovement = false;
            float currentPos = currentItem.beltPosition;
            if (stackInFront != null) {
                float diff = stackInFront.beltPosition - currentPos;
                if (Math.abs(diff) <= spacing) {
                    noMovement = true;
                }
                movement = this.beltMovementPositive ? Math.min(movement, diff - spacing) : Math.max(movement, diff + spacing);
            }
            float f = diffToEnd = this.beltMovementPositive ? (float)this.belt.beltLength - currentPos : -currentPos;
            if (Math.abs(diffToEnd) < Math.abs(movement) + 1.0f) {
                if (ending == Ending.UNRESOLVED) {
                    ending = this.resolveEnding();
                }
                diffToEnd += this.beltMovementPositive ? -ending.margin : ending.margin;
            }
            float limitedMovement = this.beltMovementPositive ? Math.min(movement, diffToEnd) : Math.max(movement, diffToEnd);
            float nextOffset = currentItem.beltPosition + limitedMovement;
            if (!onClient && horizontal) {
                class_1799 item = currentItem.stack;
                if (this.handleBeltProcessingAndCheckIfRemoved(currentItem, nextOffset, noMovement)) {
                    iterator.remove();
                    this.belt.notifyUpdate();
                    continue;
                }
                if (item != currentItem.stack) {
                    this.belt.notifyUpdate();
                }
                if (currentItem.locked) continue;
            }
            if (BeltFunnelInteractionHandler.checkForFunnels(this, currentItem, nextOffset) || noMovement || BeltTunnelInteractionHandler.flapTunnelsAndCheckIfStuck(this, currentItem, nextOffset) || BeltCrusherInteractionHandler.checkForCrushers(this, world.method_8608(), currentItem, nextOffset)) continue;
            currentItem.beltPosition += limitedMovement;
            float diffToMiddle = currentItem.getTargetSideOffset() - currentItem.sideOffset;
            currentItem.sideOffset += class_3532.method_15363((float)(diffToMiddle * Math.abs(limitedMovement) * 6.0f), (float)(-Math.abs(diffToMiddle)), (float)Math.abs(diffToMiddle));
            currentPos = currentItem.beltPosition;
            if (limitedMovement == movement || onClient) continue;
            int lastOffset = this.beltMovementPositive ? this.belt.beltLength - 1 : 0;
            class_2338 nextPosition = BeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltLength : -1);
            if (ending == Ending.FUNNEL) continue;
            if (ending == Ending.INSERT) {
                class_1799 remainder;
                DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get((class_1922)world, nextPosition, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null || !inputBehaviour.canInsertFromSide(movementFacing) || class_1799.method_7973((class_1799)(remainder = inputBehaviour.handleInsertion(currentItem, movementFacing, false)), (class_1799)currentItem.stack)) continue;
                currentItem.stack = remainder;
                if (remainder.method_7960()) {
                    this.lazyClientItem = currentItem;
                    this.lazyClientItem.locked = false;
                    iterator.remove();
                } else {
                    currentItem.stack = remainder;
                }
                BeltTunnelInteractionHandler.flapTunnel(this, lastOffset, movementFacing, false);
                this.belt.notifyUpdate();
                continue;
            }
            if (ending == Ending.BLOCKED || ending != Ending.EJECT) continue;
            this.eject(currentItem);
            iterator.remove();
            BeltTunnelInteractionHandler.flapTunnel(this, lastOffset, movementFacing, false);
            this.belt.notifyUpdate();
        }
    }

    protected boolean handleBeltProcessingAndCheckIfRemoved(TransportedItemStack currentItem, float nextOffset, boolean noMovement) {
        int currentSegment = (int)currentItem.beltPosition;
        if (currentItem.locked) {
            BeltProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(currentSegment);
            TransportedItemStackHandlerBehaviour stackHandlerBehaviour = this.getTransportedItemStackHandlerAtSegment(currentSegment);
            if (stackHandlerBehaviour == null) {
                return false;
            }
            if (processingBehaviour == null) {
                currentItem.locked = false;
                this.belt.notifyUpdate();
                return false;
            }
            BeltProcessingBehaviour.ProcessingResult result = processingBehaviour.handleHeldItem(currentItem, stackHandlerBehaviour);
            if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
                return true;
            }
            if (result == BeltProcessingBehaviour.ProcessingResult.HOLD) {
                return false;
            }
            currentItem.locked = false;
            this.belt.notifyUpdate();
            return false;
        }
        if (noMovement) {
            return false;
        }
        if (currentItem.beltPosition > 0.5f || this.beltMovementPositive) {
            int firstUpcomingSegment = (int)(currentItem.beltPosition + (this.beltMovementPositive ? 0.5f : -0.5f));
            int step = this.beltMovementPositive ? 1 : -1;
            int segment = firstUpcomingSegment;
            while (this.beltMovementPositive ? (float)segment + 0.5f <= nextOffset : (float)segment + 0.5f >= nextOffset) {
                BeltProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(segment);
                TransportedItemStackHandlerBehaviour stackHandlerBehaviour = this.getTransportedItemStackHandlerAtSegment(segment);
                if (processingBehaviour != null && stackHandlerBehaviour != null && !BeltProcessingBehaviour.isBlocked((class_1922)this.belt.method_10997(), BeltHelper.getPositionForOffset(this.belt, segment))) {
                    BeltProcessingBehaviour.ProcessingResult result = processingBehaviour.handleReceivedItem(currentItem, stackHandlerBehaviour);
                    if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
                        return true;
                    }
                    if (result == BeltProcessingBehaviour.ProcessingResult.HOLD) {
                        currentItem.beltPosition = (float)segment + 0.5f + (this.beltMovementPositive ? 0.001953125f : -0.001953125f);
                        currentItem.locked = true;
                        this.belt.notifyUpdate();
                        return false;
                    }
                }
                segment += step;
            }
        }
        return false;
    }

    protected BeltProcessingBehaviour getBeltProcessingAtSegment(int segment) {
        return BlockEntityBehaviour.get((class_1922)this.belt.method_10997(), BeltHelper.getPositionForOffset(this.belt, segment).method_10086(2), BeltProcessingBehaviour.TYPE);
    }

    protected TransportedItemStackHandlerBehaviour getTransportedItemStackHandlerAtSegment(int segment) {
        return BlockEntityBehaviour.get((class_1922)this.belt.method_10997(), BeltHelper.getPositionForOffset(this.belt, segment), TransportedItemStackHandlerBehaviour.TYPE);
    }

    private Ending resolveEnding() {
        class_2338 nextPosition;
        class_1937 world = this.belt.method_10997();
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get((class_1922)world, nextPosition = BeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltLength : -1), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour != null) {
            return Ending.INSERT;
        }
        if (BlockHelper.hasBlockSolidSide(world.method_8320(nextPosition), (class_1922)world, nextPosition, this.belt.getMovementFacing().method_10153())) {
            return Ending.BLOCKED;
        }
        return Ending.EJECT;
    }

    public boolean canInsertAt(int segment) {
        return this.canInsertAtFromSide(segment, class_2350.field_11036);
    }

    public boolean canInsertAtFromSide(int segment, class_2350 side) {
        float segmentPos = segment;
        if (this.belt.getMovementFacing() == side.method_10153()) {
            return false;
        }
        if (this.belt.getMovementFacing() != side) {
            segmentPos += 0.5f;
        } else if (!this.beltMovementPositive) {
            segmentPos += 1.0f;
        }
        for (TransportedItemStack stack : this.items) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        for (TransportedItemStack stack : this.toInsert) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlocking(int segment, class_2350 side, float segmentPos, TransportedItemStack stack) {
        float currentPos = stack.beltPosition;
        return stack.insertedAt == segment && stack.insertedFrom == side && (this.beltMovementPositive ? currentPos <= segmentPos + 1.0f : currentPos >= segmentPos - 1.0f);
    }

    public void addItem(TransportedItemStack newStack) {
        this.toInsert.add(newStack);
    }

    private void insert(TransportedItemStack newStack) {
        if (this.items.isEmpty()) {
            this.items.add(newStack);
        } else {
            int index = 0;
            for (TransportedItemStack stack : this.items) {
                if (stack.compareTo(newStack) > 0 == this.beltMovementPositive) break;
                ++index;
            }
            this.items.add(index, newStack);
        }
    }

    public TransportedItemStack getStackAtOffset(int offset) {
        float min = offset;
        float max = offset + 1;
        for (TransportedItemStack stack : this.items) {
            if (this.toRemove.contains(stack) || stack.beltPosition > max || !(stack.beltPosition > min)) continue;
            return stack;
        }
        return null;
    }

    public void read(class_11368 view) {
        this.items.clear();
        class_11368.class_11369 list = view.method_71437("Items", TransportedItemStack.CODEC);
        list.forEach(this.items::add);
        this.lazyClientItem = view.method_71426("LazyItem", TransportedItemStack.CODEC).orElse(null);
        this.beltMovementPositive = view.method_71433("PositiveOrder", false);
    }

    public void write(class_11372 view) {
        class_11372.class_11373 list = view.method_71467("Items", TransportedItemStack.CODEC);
        this.items.forEach(arg_0 -> ((class_11372.class_11373)list).method_71484(arg_0));
        if (this.lazyClientItem != null) {
            view.method_71468("LazyItem", TransportedItemStack.CODEC, (Object)this.lazyClientItem);
        }
        view.method_71472("PositiveOrder", this.beltMovementPositive);
    }

    public void eject(TransportedItemStack stack) {
        class_1799 ejected = stack.stack;
        class_243 outPos = BeltHelper.getVectorForOffset(this.belt, stack.beltPosition);
        float movementSpeed = Math.max(Math.abs(this.belt.getBeltMovementSpeed()), 0.125f);
        class_243 outMotion = class_243.method_24954((class_2382)this.belt.getBeltChainDirection()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
        outPos = outPos.method_1019(outMotion.method_1029().method_1021(0.001));
        class_1542 entity = new class_1542(this.belt.method_10997(), outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
        entity.method_18799(outMotion);
        entity.method_6988();
        entity.field_6037 = true;
        this.belt.method_10997().method_8649((class_1297)entity);
    }

    public void ejectAll() {
        this.items.forEach(this::eject);
        this.items.clear();
    }

    public void applyToEachWithin(float position, float maxDistanceToPosition, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        boolean dirty = false;
        for (TransportedItemStack transported : this.items) {
            TransportedItemStackHandlerBehaviour.TransportedResult result;
            if (this.toRemove.contains(transported)) continue;
            class_1799 stackBefore = transported.stack.method_7972();
            if (Math.abs(position - transported.beltPosition) >= maxDistanceToPosition || (result = processFunction.apply(transported)) == null || result.didntChangeFrom(stackBefore)) continue;
            dirty = true;
            if (result.hasHeldOutput()) {
                TransportedItemStack held = result.getHeldOutput();
                held.beltPosition = (float)((int)position) + 0.5f - (this.beltMovementPositive ? 0.001953125f : -0.001953125f);
                this.toInsert.add(held);
            }
            this.toInsert.addAll(result.getOutputs());
            this.toRemove.add(transported);
        }
        if (dirty) {
            this.belt.notifyUpdate();
        }
    }

    public List<TransportedItemStack> getTransportedItems() {
        return this.items;
    }

    @Nullable
    public TransportedItemStack getLazyClientItem() {
        return this.lazyClientItem;
    }

    private static enum Ending {
        UNRESOLVED(0.0f),
        EJECT(0.0f),
        INSERT(0.25f),
        FUNNEL(0.5f),
        BLOCKED(0.45f);

        private float margin;

        private Ending(float f) {
            this.margin = f;
        }
    }
}

