/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.CrafterHelper;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class MechanicalCrafterBlock
extends HorizontalKineticBlock
implements IBE<MechanicalCrafterBlockEntity>,
ICogWheel,
ItemInventoryProvider<MechanicalCrafterBlockEntity>,
NeighborUpdateListeningBlock {
    public static final class_2754<Pointing> POINTING = class_2754.method_11850((String)"pointing", Pointing.class);

    public MechanicalCrafterBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657(POINTING, (Comparable)((Object)Pointing.UP)));
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, MechanicalCrafterBlockEntity blockEntity, class_2350 context) {
        return blockEntity.getInvCapability();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)builder.method_11667(new class_2769[]{POINTING}));
    }

    @Override
    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)).method_10166();
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 face = context.method_8038();
        class_2338 placedOnPos = context.method_8037().method_10093(face.method_10153());
        class_2680 blockState = context.method_8045().method_8320(placedOnPos);
        if (blockState.method_26204() != this || context.method_8036() != null && context.method_8036().method_5715()) {
            class_2680 stateForPlacement = super.method_9605(context);
            class_2350 direction = (class_2350)stateForPlacement.method_11654((class_2769)HORIZONTAL_FACING);
            if (direction != face) {
                stateForPlacement = (class_2680)stateForPlacement.method_11657(POINTING, (Comparable)((Object)MechanicalCrafterBlock.pointingFromFacing(face, direction)));
            }
            return stateForPlacement;
        }
        class_2350 otherFacing = (class_2350)blockState.method_11654((class_2769)HORIZONTAL_FACING);
        Pointing pointing = MechanicalCrafterBlock.pointingFromFacing(face, otherFacing);
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)HORIZONTAL_FACING, (Comparable)otherFacing)).method_11657(POINTING, (Comparable)((Object)pointing));
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        MechanicalCrafterBlockEntity crafter;
        if (oldState.method_27852((class_2248)this) && MechanicalCrafterBlock.getTargetDirection(state) != MechanicalCrafterBlock.getTargetDirection(oldState) && (crafter = CrafterHelper.getCrafter((class_1920)worldIn, pos)) != null) {
            crafter.blockChanged();
        }
    }

    public void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
        if (state.method_31709()) {
            MechanicalCrafterBlockEntity crafter = CrafterHelper.getCrafter((class_1920)worldIn, pos);
            if (crafter != null) {
                if (crafter.covered) {
                    class_2248.method_9577((class_1937)worldIn, (class_2338)pos, (class_1799)AllItems.CRAFTER_SLOT_COVER.method_7854());
                }
                if (!isMoving) {
                    crafter.ejectWholeGrid();
                }
            }
            for (class_2350 direction : Iterate.directions) {
                if (direction.method_10166() == ((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)).method_10166()) continue;
                class_2338 otherPos = pos.method_10093(direction);
                ConnectedInputHandler.ConnectedInput thisInput = CrafterHelper.getInput((class_1920)worldIn, pos);
                ConnectedInputHandler.ConnectedInput otherInput = CrafterHelper.getInput((class_1920)worldIn, otherPos);
                if (thisInput == null || otherInput == null || !pos.method_10081((class_2382)thisInput.data.getFirst()).equals((Object)otherPos.method_10081((class_2382)otherInput.data.getFirst()))) continue;
                ConnectedInputHandler.toggleConnection((class_1937)worldIn, pos, otherPos);
            }
        }
        super.method_66388(state, worldIn, pos, isMoving);
    }

    public static Pointing pointingFromFacing(class_2350 pointingFace, class_2350 blockFacing) {
        Pointing pointing;
        boolean positive = blockFacing.method_10171() == class_2350.class_2352.field_11056;
        Pointing pointing2 = pointing = pointingFace == class_2350.field_11033 ? Pointing.UP : Pointing.DOWN;
        if (pointingFace == class_2350.field_11034) {
            Pointing pointing3 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == class_2350.field_11039) {
            Pointing pointing4 = pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        if (pointingFace == class_2350.field_11043) {
            Pointing pointing5 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == class_2350.field_11035) {
            pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        return pointing;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (context.method_8038() == state.method_11654((class_2769)HORIZONTAL_FACING)) {
            if (!context.method_8045().method_8608()) {
                KineticBlockEntity.switchToBlockState(context.method_8045(), context.method_8037(), (class_2680)state.method_28493(POINTING));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof MechanicalCrafterBlockEntity)) {
            return class_1269.field_52423;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)blockEntity;
        if (stack.method_31574((class_1792)AllItems.MECHANICAL_ARM)) {
            return class_1269.field_52423;
        }
        boolean isHand = stack.method_7960() && hand == class_1268.field_5808;
        boolean wrenched = stack.method_31574((class_1792)AllItems.WRENCH);
        if (hitResult.method_17780() == state.method_11654((class_2769)HORIZONTAL_FACING)) {
            if (crafter.phase != MechanicalCrafterBlockEntity.Phase.IDLE && !wrenched) {
                crafter.ejectWholeGrid();
                return class_1269.field_5812;
            }
            if (crafter.phase == MechanicalCrafterBlockEntity.Phase.IDLE && !isHand && !wrenched) {
                if (level.method_8608()) {
                    return class_1269.field_5812;
                }
                if (stack.method_31574(AllItems.CRAFTER_SLOT_COVER)) {
                    if (crafter.covered) {
                        return class_1269.field_52423;
                    }
                    if (!crafter.inventory.method_5442()) {
                        return class_1269.field_52423;
                    }
                    crafter.covered = true;
                    crafter.method_5431();
                    crafter.sendData();
                    if (!player.method_68878()) {
                        stack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
                class_1263 capability = crafter.getInvCapability();
                if (capability == null) {
                    return class_1269.field_52423;
                }
                int count = stack.method_7947();
                int insert = capability.insert(stack);
                if (!player.method_68878()) {
                    if (insert == count) {
                        player.method_6122(hand, class_1799.field_8037);
                    } else if (insert != 0) {
                        stack.method_7939(count - insert);
                        player.method_6122(hand, stack);
                    }
                }
                return class_1269.field_5812;
            }
            MechanicalCrafterBlockEntity.CrafterItemHandler handler = crafter.getInventory();
            class_1799 inSlot = handler.getStack();
            if (inSlot.method_7960()) {
                if (crafter.covered && !wrenched) {
                    if (level.method_8608()) {
                        return class_1269.field_5812;
                    }
                    crafter.covered = false;
                    crafter.method_5431();
                    crafter.sendData();
                    if (!player.method_68878()) {
                        player.method_31548().method_7398(AllItems.CRAFTER_SLOT_COVER.method_7854());
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_52423;
            }
            if (!isHand && !handler.matches(stack, inSlot)) {
                return class_1269.field_52423;
            }
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            player.method_31548().method_7398(handler.onExtract(inSlot));
            handler.setStack(class_1799.field_8037);
            handler.method_5431();
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 sourceBlock, class_2338 fromPos, boolean isMoving) {
        InvManipulationBehaviour behaviour = BlockEntityBehaviour.get((class_1922)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.85f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.75f;
    }

    public static class_2350 getTargetDirection(class_2680 state) {
        if (!state.method_27852((class_2248)AllBlocks.MECHANICAL_CRAFTER)) {
            return class_2350.field_11036;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
        Pointing point = (Pointing)((Object)state.method_11654(POINTING));
        class_243 targetVec = new class_243(0.0, 1.0, 0.0);
        targetVec = VecHelper.rotate(targetVec, -point.getXRotation(), class_2350.class_2351.field_11051);
        targetVec = VecHelper.rotate(targetVec, AngleHelper.horizontalAngle(facing), class_2350.class_2351.field_11052);
        return class_2350.method_10142((double)targetVec.field_1352, (double)targetVec.field_1351, (double)targetVec.field_1350);
    }

    public static boolean isValidTarget(class_1937 world, class_2338 targetPos, class_2680 crafterState) {
        class_2680 targetState = world.method_8320(targetPos);
        if (!world.method_8477(targetPos)) {
            return false;
        }
        if (!targetState.method_27852((class_2248)AllBlocks.MECHANICAL_CRAFTER)) {
            return false;
        }
        if (crafterState.method_11654((class_2769)HORIZONTAL_FACING) != targetState.method_11654((class_2769)HORIZONTAL_FACING)) {
            return false;
        }
        return Math.abs(((Pointing)((Object)crafterState.method_11654(POINTING))).getXRotation() - ((Pointing)((Object)targetState.method_11654(POINTING))).getXRotation()) != 180;
    }

    @Override
    public Class<MechanicalCrafterBlockEntity> getBlockEntityClass() {
        return MechanicalCrafterBlockEntity.class;
    }

    @Override
    public class_2591<? extends MechanicalCrafterBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MECHANICAL_CRAFTER;
    }
}

