/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crusher;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_4844;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public class CrushingWheelControllerBlockEntity
extends SmartBlockEntity
implements class_3829 {
    public class_1297 processingEntity;
    public UUID entityUUID;
    protected boolean searchForEntity;
    public ProcessingInventory inventory = new ProcessingInventory(this::itemInserted, d -> this.processingEntity == null);
    public float crushingspeed;

    public CrushingWheelControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CRUSHING_WHEEL_CONTROLLER, pos, state);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.inventory);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput));
    }

    private boolean supportsDirectBeltInput(class_2350 side) {
        class_2680 blockState = this.method_11010();
        if (blockState == null) {
            return false;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)CrushingWheelControllerBlock.field_10927);
        return direction == class_2350.field_11033 || direction == side;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.searchForEntity) {
            this.searchForEntity = false;
            List search = this.field_11863.method_8333(null, new class_238(this.method_11016()), e -> this.entityUUID.equals(e.method_5667()));
            if (search.isEmpty()) {
                this.clearEntity();
            } else {
                this.processingEntity = (class_1297)search.getFirst();
            }
        }
        if (!this.isOccupied()) {
            return;
        }
        if (this.crushingspeed == 0.0f) {
            return;
        }
        float speed = this.crushingspeed * 4.0f;
        class_243 centerPos = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)CrushingWheelControllerBlock.field_10927);
        int offset = facing.method_10171().method_10181();
        class_243 outSpeed = new class_243((facing.method_10166() == class_2350.class_2351.field_11048 ? 0.25 : 0.0) * (double)offset, offset == 1 ? (facing.method_10166() == class_2350.class_2351.field_11052 ? 0.5 : 0.0) : 0.0, (facing.method_10166() == class_2350.class_2351.field_11051 ? 0.25 : 0.0) * (double)offset);
        class_243 outPos = centerPos.method_1031((double)(facing.method_10166() == class_2350.class_2351.field_11048 ? 0.55f * (float)offset : 0.0f), (double)(facing.method_10166() == class_2350.class_2351.field_11052 ? 0.55f * (float)offset : 0.0f), (double)(facing.method_10166() == class_2350.class_2351.field_11051 ? 0.55f * (float)offset : 0.0f));
        if (!this.hasEntity()) {
            class_2338 nextPos;
            DirectBeltInputBehaviour behaviour;
            float processingSpeed = class_3532.method_15363((float)(speed / (!this.inventory.appliedRecipe ? (float)Math.log(this.inventory.method_5438(0).method_7947()) / (float)Math.log(2.0) : 1.0f)), (float)0.25f, (float)20.0f);
            this.inventory.remainingTime -= processingSpeed;
            this.spawnParticles(this.inventory.method_5438(0));
            if (this.field_11863.method_8608()) {
                return;
            }
            if (this.inventory.remainingTime < 20.0f && !this.inventory.appliedRecipe) {
                this.applyRecipe();
                this.inventory.appliedRecipe = true;
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 18);
                return;
            }
            if (this.inventory.remainingTime > 0.0f) {
                return;
            }
            this.inventory.remainingTime = 0.0f;
            if (facing != class_2350.field_11036 && (behaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, nextPos = this.field_11867.method_10074().method_10079(facing, facing.method_10166() == class_2350.class_2351.field_11052 ? 0 : 1), DirectBeltInputBehaviour.TYPE)) != null) {
                boolean changed = false;
                if (!behaviour.canInsertFromSide(facing)) {
                    return;
                }
                int size = this.inventory.method_5439();
                for (int slot = 0; slot < size; ++slot) {
                    class_1799 remainder;
                    class_1799 stack = this.inventory.method_5438(slot);
                    if (stack.method_7960() || class_1799.method_7973((class_1799)(remainder = behaviour.handleInsertion(stack, facing, false)), (class_1799)stack)) continue;
                    this.inventory.method_5447(slot, remainder);
                    changed = true;
                }
                if (changed) {
                    this.method_5431();
                    this.sendData();
                }
                return;
            }
            int size = this.inventory.method_5439();
            for (int slot = 0; slot < size; ++slot) {
                class_1799 stack = this.inventory.method_5438(slot);
                if (stack.method_7960()) continue;
                class_1542 entityIn = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, stack);
                entityIn.method_18799(outSpeed);
                AllSynchedDatas.BYPASS_CRUSHING_WHEEL.set((class_1297)entityIn, Optional.of(this.field_11867));
                this.field_11863.method_8649((class_1297)entityIn);
            }
            this.inventory.method_5448();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 18);
            return;
        }
        if (!this.processingEntity.method_5805() || !this.processingEntity.method_5829().method_994(new class_238(this.field_11867).method_1014(0.5))) {
            this.clearEntity();
            return;
        }
        double xMotion = ((double)((float)this.field_11867.method_10263() + 0.5f) - this.processingEntity.method_23317()) / 2.0;
        double zMotion = ((double)((float)this.field_11867.method_10260() + 0.5f) - this.processingEntity.method_23321()) / 2.0;
        if (this.processingEntity.method_5715()) {
            zMotion = 0.0;
            xMotion = 0.0;
        }
        double movement = Math.max(-speed / 4.0f, -0.5f) * (float)(-offset);
        this.processingEntity.method_18799(new class_243(facing.method_10166() == class_2350.class_2351.field_11048 ? movement : xMotion, facing.method_10166() == class_2350.class_2351.field_11052 ? movement : 0.0, facing.method_10166() == class_2350.class_2351.field_11051 ? movement : zMotion));
        if (this.field_11863.method_8608()) {
            return;
        }
        class_1297 remainder = this.processingEntity;
        if (!(remainder instanceof class_1542)) {
            class_1309 livingEntity;
            class_243 entityOutPos = outPos.method_1031(facing.method_10166() == class_2350.class_2351.field_11048 ? (double)(0.5f * (float)offset) : 0.0, facing.method_10166() == class_2350.class_2351.field_11052 ? (double)(0.5f * (float)offset) : 0.0, facing.method_10166() == class_2350.class_2351.field_11051 ? (double)(0.5f * (float)offset) : 0.0);
            int crusherDamage = (Integer)AllConfigs.server().kinetics.crushingDamage.get();
            class_1297 class_12972 = this.processingEntity;
            if (class_12972 instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6032() - (float)crusherDamage <= 0.0f && livingEntity.field_6235 <= 0) {
                this.processingEntity.method_23327(entityOutPos.field_1352, entityOutPos.field_1351, entityOutPos.field_1350);
            }
            this.processingEntity.method_64397((class_3218)this.field_11863, AllDamageSources.get((class_1937)this.field_11863).crush, (float)crusherDamage);
            if (!this.processingEntity.method_5805()) {
                this.processingEntity.method_23327(entityOutPos.field_1352, entityOutPos.field_1351, entityOutPos.field_1350);
            }
            return;
        }
        class_1542 itemEntity = (class_1542)remainder;
        itemEntity.method_6982(20);
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            if (this.processingEntity.method_23318() * (double)(-offset) < (centerPos.field_1351 - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (facing.method_10166() == class_2350.class_2351.field_11051) {
            if (this.processingEntity.method_23321() * (double)(-offset) < (centerPos.field_1350 - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (this.processingEntity.method_23317() * (double)(-offset) < (centerPos.field_1352 - 0.25) * (double)(-offset)) {
            this.intakeItem(itemEntity);
        }
    }

    private void intakeItem(class_1542 itemEntity) {
        this.inventory.method_5448();
        this.inventory.method_5447(0, itemEntity.method_6983().method_7972());
        this.itemInserted(this.inventory.method_5438(0));
        itemEntity.method_31472();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 18);
    }

    protected void spawnParticles(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        Object particleData = stack.method_7909() instanceof class_1747 ? new class_2388(class_2398.field_11217, ((class_1747)stack.method_7909()).method_7711().method_9564()) : new class_2392(class_2398.field_11218, stack);
        class_5819 r = this.field_11863.field_9229;
        int x = this.field_11867.method_10263();
        int y = this.field_11867.method_10264();
        int z = this.field_11867.method_10260();
        for (int i = 0; i < 4; ++i) {
            this.field_11863.method_8406((class_2394)particleData, (double)((float)x + r.method_43057()), (double)((float)y + r.method_43057()), (double)((float)z + r.method_43057()), 0.0, 0.0, 0.0);
        }
    }

    private void applyRecipe() {
        AbstractCrushingRecipe recipe = this.findRecipe();
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (recipe != null) {
            class_1799 item = this.inventory.method_5438(0);
            class_9696 input = new class_9696(item);
            int rolls = item.method_7947();
            this.inventory.method_5448();
            class_1799 recipeRemainder = item.method_7909().method_7858();
            if (recipeRemainder.method_7960()) {
                recipeRemainder = null;
            }
            for (int roll = 0; roll < rolls; ++roll) {
                List<class_1799> rolledResults = recipe.craft(input, this.field_11863.field_9229);
                for (class_1799 stack : rolledResults) {
                    ItemHelper.addToList(stack, list);
                }
                if (recipeRemainder == null) continue;
                ItemHelper.addToList(recipeRemainder, list);
            }
            int max = Math.min(list.size(), this.inventory.method_5439() - 1);
            for (int slot = 0; slot < max; ++slot) {
                this.inventory.method_5447(slot + 1, (class_1799)list.get(slot));
            }
        } else {
            this.inventory.method_5448();
        }
    }

    public AbstractCrushingRecipe findRecipe() {
        class_9696 input;
        class_1863 recipeManager = ((class_3218)this.field_11863).method_64577();
        AbstractCrushingRecipe crushingRecipe = recipeManager.method_8132(AllRecipeTypes.CRUSHING, (class_9695)(input = new class_9696(this.inventory.method_5438(0))), this.field_11863).map(class_8786::comp_1933).orElse(null);
        if (crushingRecipe == null) {
            crushingRecipe = recipeManager.method_8132(AllRecipeTypes.MILLING, (class_9695)input, this.field_11863).map(class_8786::comp_1933).orElse(null);
        }
        return crushingRecipe;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (this.hasEntity()) {
            view.method_71468("Entity", class_4844.field_25122, (Object)this.entityUUID);
        }
        this.inventory.write(view);
        view.method_71464("Speed", this.crushingspeed);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        view.method_71426("Entity", class_4844.field_25122).ifPresent(uuid -> {
            if (!this.isOccupied()) {
                this.entityUUID = uuid;
                this.searchForEntity = true;
            }
        });
        this.crushingspeed = view.method_71423("Speed", 0.0f);
        this.inventory.read(view);
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    public void startCrushing(class_1297 entity) {
        this.processingEntity = entity;
        this.entityUUID = entity.method_5667();
    }

    private void itemInserted(class_1799 stack) {
        AbstractCrushingRecipe recipe = this.findRecipe();
        this.inventory.remainingTime = recipe != null ? (float)recipe.time() : 100.0f;
        this.inventory.appliedRecipe = false;
    }

    public void clearEntity() {
        this.processingEntity = null;
        this.entityUUID = null;
    }

    public boolean isOccupied() {
        return this.hasEntity() || !this.inventory.method_5442();
    }

    public boolean hasEntity() {
        return this.processingEntity != null;
    }
}

