/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmAngleTarget;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2387;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2802;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public class ArmBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity {
    public Codec<ArmInteractionPoint> pointCodec;
    public List<ArmInteractionPoint> inputs = new ArrayList<ArmInteractionPoint>();
    public List<ArmInteractionPoint> outputs = new ArrayList<ArmInteractionPoint>();
    public class_2499 interactionPointTag = null;
    float chasedPointProgress;
    int chasedPointIndex;
    public class_1799 heldItem = class_1799.field_8037;
    public Phase phase = Phase.SEARCH_INPUTS;
    public boolean goggles;
    ArmAngleTarget previousTarget = ArmAngleTarget.NO_TARGET;
    public LerpedFloat lowerArmAngle;
    public LerpedFloat upperArmAngle;
    public LerpedFloat baseAngle = LerpedFloat.angular();
    public LerpedFloat headAngle;
    LerpedFloat clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    public int tooltipWarmup;
    protected ServerScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;

    public ArmBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_ARM, pos, state);
        this.baseAngle.startWithValue(this.previousTarget.baseAngle);
        this.lowerArmAngle = LerpedFloat.angular();
        this.lowerArmAngle.startWithValue(this.previousTarget.lowerArmAngle);
        this.upperArmAngle = LerpedFloat.angular();
        this.upperArmAngle.startWithValue(this.previousTarget.upperArmAngle);
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue(this.previousTarget.headAngle);
        this.clawAngle = LerpedFloat.angular();
        this.previousBaseAngle = this.previousTarget.baseAngle;
        this.updateInteractionPoints = true;
        this.redstoneLocked = false;
        this.tooltipWarmup = 15;
        this.goggles = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ServerScrollOptionBehaviour<SelectionMode>(SelectionMode.class, this);
        behaviours.add(this.selectionMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.ARM_BLAZE_BURNER, AllAdvancements.ARM_MANY_TARGETS, AllAdvancements.MECHANICAL_ARM, AllAdvancements.MUSICAL_ARM);
    }

    @Override
    public void tick() {
        super.tick();
        this.initInteractionPoints();
        boolean targetReached = this.tickMovementProgress();
        if (this.tooltipWarmup > 0) {
            --this.tooltipWarmup;
        }
        if (this.chasedPointProgress < 1.0f) {
            ArmInteractionPoint point;
            if (this.phase == Phase.MOVE_TO_INPUT && (point = this.getTargetedInteractionPoint()) != null) {
                point.keepAlive();
            }
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.phase == Phase.MOVE_TO_INPUT) {
            this.collectItem();
        } else if (this.phase == Phase.MOVE_TO_OUTPUT) {
            this.depositItem();
        } else if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.searchForItem();
        }
        if (targetReached) {
            this.lazyTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.chasedPointProgress < 0.5f) {
            return;
        }
        if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.checkForMusic();
        }
        if (this.phase == Phase.SEARCH_OUTPUTS) {
            this.searchForDestination();
        }
    }

    private void checkForMusic() {
        boolean hasMusic = this.checkForMusicAmong(this.inputs) || this.checkForMusicAmong(this.outputs);
        if (hasMusic != (this.phase == Phase.DANCING)) {
            this.phase = hasMusic ? Phase.DANCING : Phase.SEARCH_INPUTS;
            this.method_5431();
            this.sendData();
        }
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(3.0);
    }

    private boolean checkForMusicAmong(List<ArmInteractionPoint> list) {
        for (ArmInteractionPoint armInteractionPoint : list) {
            class_2680 state;
            if (!(armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint) || !((Boolean)(state = this.field_11863.method_8320(armInteractionPoint.getPos())).method_61767((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(false))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = this.chasedPointProgress >= 1.0f;
        this.chasedPointProgress += Math.min(256.0f, Math.abs(this.getSpeed())) / 1024.0f;
        if (this.chasedPointProgress > 1.0f) {
            this.chasedPointProgress = 1.0f;
        }
        if (!this.field_11863.method_8608()) {
            return !targetReachedPreviously && this.chasedPointProgress >= 1.0f;
        }
        ArmInteractionPoint targetedInteractionPoint = this.getTargetedInteractionPoint();
        ArmAngleTarget previousTarget = this.previousTarget;
        ArmAngleTarget target = targetedInteractionPoint == null ? ArmAngleTarget.NO_TARGET : targetedInteractionPoint.getTargetAngles(this.field_11867, this.isOnCeiling());
        this.baseAngle.setValue(AngleHelper.angleLerp(this.chasedPointProgress, this.previousBaseAngle, target == ArmAngleTarget.NO_TARGET ? (double)this.previousBaseAngle : (double)target.baseAngle));
        if (this.chasedPointProgress < 0.5f) {
            target = ArmAngleTarget.NO_TARGET;
        } else {
            previousTarget = ArmAngleTarget.NO_TARGET;
        }
        float progress = this.chasedPointProgress == 1.0f ? 1.0f : this.chasedPointProgress % 0.5f * 2.0f;
        this.lowerArmAngle.setValue(class_3532.method_16439((float)progress, (float)previousTarget.lowerArmAngle, (float)target.lowerArmAngle));
        this.upperArmAngle.setValue(class_3532.method_16439((float)progress, (float)previousTarget.upperArmAngle, (float)target.upperArmAngle));
        this.headAngle.setValue(AngleHelper.angleLerp(progress, previousTarget.headAngle % 360.0f, target.headAngle % 360.0f));
        return false;
    }

    protected boolean isOnCeiling() {
        class_2680 state = this.method_11010();
        return this.method_11002() && (Boolean)state.method_61767((class_2769)ArmBlock.CEILING, (Comparable)Boolean.valueOf(false)) != false;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (!this.heldItem.method_7960()) {
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)this.heldItem);
        }
    }

    @Nullable
    private ArmInteractionPoint getTargetedInteractionPoint() {
        if (this.chasedPointIndex == -1) {
            return null;
        }
        if (this.phase == Phase.MOVE_TO_INPUT && this.chasedPointIndex < this.inputs.size()) {
            return this.inputs.get(this.chasedPointIndex);
        }
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointIndex < this.outputs.size()) {
            return this.outputs.get(this.chasedPointIndex);
        }
        return null;
    }

    protected void searchForItem() {
        int scanRange;
        if (this.redstoneLocked) {
            return;
        }
        boolean foundInput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastInputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastInputIndex + 2 : this.inputs.size();
        if (scanRange > this.inputs.size()) {
            scanRange = this.inputs.size();
        }
        block0: for (int i = startIndex; i < scanRange; ++i) {
            ArmInteractionPoint armInteractionPoint = this.inputs.get(i);
            if (!armInteractionPoint.isValid()) continue;
            for (int j = 0; j < armInteractionPoint.getSlotCount(this); ++j) {
                if (this.getDistributableAmount(armInteractionPoint, j) == 0) continue;
                this.selectIndex(true, i);
                foundInput = true;
                break block0;
            }
        }
        if (!foundInput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastInputIndex = -1;
        }
        if (this.lastInputIndex == this.inputs.size() - 1) {
            this.lastInputIndex = -1;
        }
    }

    protected void searchForDestination() {
        int scanRange;
        class_1799 held = this.heldItem.method_7972();
        boolean foundOutput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastOutputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastOutputIndex + 2 : this.outputs.size();
        if (scanRange > this.outputs.size()) {
            scanRange = this.outputs.size();
        }
        for (int i = startIndex; i < scanRange; ++i) {
            class_1799 remainder;
            ArmInteractionPoint armInteractionPoint = this.outputs.get(i);
            if (!armInteractionPoint.isValid() || class_1799.method_7973((class_1799)(remainder = armInteractionPoint.insert(this, held, true)), (class_1799)this.heldItem)) continue;
            this.selectIndex(false, i);
            foundOutput = true;
            break;
        }
        if (!foundOutput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastOutputIndex = -1;
        }
        if (this.lastOutputIndex == this.outputs.size() - 1) {
            this.lastOutputIndex = -1;
        }
    }

    private void selectIndex(boolean input, int index) {
        this.phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        this.chasedPointIndex = index;
        this.chasedPointProgress = 0.0f;
        if (input) {
            this.lastInputIndex = index;
        } else {
            this.lastOutputIndex = index;
        }
        this.sendData();
        this.method_5431();
    }

    protected int getDistributableAmount(ArmInteractionPoint armInteractionPoint, int i) {
        class_1799 remainder;
        class_1799 stack = armInteractionPoint.extract(this, i, true);
        if (class_1799.method_7984((class_1799)stack, (class_1799)(remainder = this.simulateInsertion(stack)))) {
            return stack.method_7947() - remainder.method_7947();
        }
        return stack.method_7947();
    }

    private class_1799 simulateInsertion(class_1799 stack) {
        for (ArmInteractionPoint armInteractionPoint : this.outputs) {
            if (armInteractionPoint.isValid()) {
                stack = armInteractionPoint.insert(this, stack, true);
            }
            if (!stack.method_7960()) continue;
            break;
        }
        return stack;
    }

    protected void depositItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            class_1799 remainder;
            class_1799 toInsert = this.heldItem.method_7972();
            this.heldItem = remainder = armInteractionPoint.insert(this, toInsert, false);
            if (armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint && remainder.method_7960()) {
                this.award(AllAdvancements.MUSICAL_ARM);
            }
        }
        this.phase = this.heldItem.method_7960() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.method_5431();
        if (!this.field_11863.method_8608()) {
            this.award(AllAdvancements.MECHANICAL_ARM);
        }
    }

    protected void collectItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            for (int i = 0; i < armInteractionPoint.getSlotCount(this); ++i) {
                int amountExtracted = this.getDistributableAmount(armInteractionPoint, i);
                if (amountExtracted == 0) continue;
                class_1799 prevHeld = this.heldItem;
                this.heldItem = armInteractionPoint.extract(this, i, amountExtracted, false);
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.method_5431();
                if (!class_1799.method_7984((class_1799)this.heldItem, (class_1799)prevHeld)) {
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15245, 0.125f, 0.5f + this.field_11863.field_9229.method_43057() * 0.25f);
                }
                return;
            }
        }
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.method_5431();
    }

    public void redstoneUpdate() {
        if (this.field_11863.method_8608()) {
            return;
        }
        boolean blockPowered = this.field_11863.method_49803(this.field_11867);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
        if (!this.redstoneLocked) {
            this.searchForItem();
        }
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        if (this.interactionPointTag == null) {
            return;
        }
        for (class_2520 tag : this.interactionPointTag) {
            ArmInteractionPoint.transformPos((class_2487)tag, transform);
        }
        this.notifyUpdate();
    }

    protected boolean isAreaActuallyLoaded(class_2338 center, int range) {
        if (!this.field_11863.method_22343(center.method_10069(-range, -range, -range), center.method_10069(range, range, range))) {
            return false;
        }
        if (this.field_11863.method_8608()) {
            int minY = center.method_10264() - range;
            int maxY = center.method_10264() + range;
            if (maxY < this.field_11863.method_31607() || minY >= this.field_11863.method_31600()) {
                return false;
            }
            int minX = center.method_10263() - range;
            int minZ = center.method_10260() - range;
            int maxX = center.method_10263() + range;
            int maxZ = center.method_10260() + range;
            int minChunkX = class_4076.method_18675((int)minX);
            int maxChunkX = class_4076.method_18675((int)maxX);
            int minChunkZ = class_4076.method_18675((int)minZ);
            int maxChunkZ = class_4076.method_18675((int)maxZ);
            class_2802 chunkSource = this.field_11863.method_8398();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (chunkSource.method_12123(chunkX, chunkZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void initInteractionPoints() {
        if (!this.updateInteractionPoints || this.interactionPointTag == null) {
            return;
        }
        if (!this.isAreaActuallyLoaded(this.field_11867, ArmBlockEntity.getRange() + 1)) {
            return;
        }
        this.inputs.clear();
        this.outputs.clear();
        boolean hasBlazeBurner = false;
        if (this.pointCodec == null) {
            this.pointCodec = ArmInteractionPoint.getCodec(this.field_11863, this.field_11867);
        }
        for (class_2520 tag : this.interactionPointTag) {
            class_2680 state;
            ArmInteractionPoint point = this.decodePoint(tag);
            if (point == null || !point.type.canCreatePoint(this.field_11863, point.pos, state = this.field_11863.method_8320(point.pos))) continue;
            if (point.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                this.outputs.add(point);
            } else if (point.getMode() == ArmInteractionPoint.Mode.TAKE) {
                this.inputs.add(point);
            }
            hasBlazeBurner |= point instanceof AllArmInteractionPointTypes.BlazeBurnerPoint;
        }
        if (!this.field_11863.method_8608()) {
            if (this.outputs.size() >= 10) {
                this.award(AllAdvancements.ARM_MANY_TARGETS);
            }
            if (hasBlazeBurner) {
                this.award(AllAdvancements.ARM_BLAZE_BURNER);
            }
        }
        this.updateInteractionPoints = false;
        this.sendData();
        this.method_5431();
    }

    public void writeInteractionPoints(class_11372 view) {
        class_2499 list;
        if (this.pointCodec == null) {
            this.pointCodec = ArmInteractionPoint.getCodec(this.field_11863, this.field_11867);
        }
        if (this.updateInteractionPoints && this.interactionPointTag != null) {
            list = this.interactionPointTag;
        } else {
            list = new class_2499();
            ArmBlockEntity.appendEncodedPoints(this.inputs, this.pointCodec, list);
            ArmBlockEntity.appendEncodedPoints(this.outputs, this.pointCodec, list);
        }
        view.method_71468("InteractionPoints", CreateCodecs.NBT_LIST_CODEC, (Object)list);
    }

    public static void appendEncodedPoints(List<ArmInteractionPoint> points, Codec<ArmInteractionPoint> pointCodec, class_2499 list) {
        block4: for (ArmInteractionPoint point : points) {
            DataResult dataResult;
            Objects.requireNonNull(pointCodec.encodeStart((DynamicOps)class_2509.field_11560, (Object)point));
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success success = (DataResult.Success)dataResult;
                    list.add((Object)((class_2520)success.value()));
                    continue block4;
                }
                case 1: 
            }
            DataResult.Error error = (DataResult.Error)dataResult;
            Create.LOGGER.warn("Failed to append value '{}' to list 'InteractionPoints': {}", (Object)point, (Object)error.message());
        }
    }

    public ArmInteractionPoint decodePoint(class_2520 tag) {
        DataResult dataResult = this.pointCodec.parse((DynamicOps)class_2509.field_11560, (Object)tag);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DataResult.Success success = (DataResult.Success)dataResult2;
                yield (ArmInteractionPoint)success.value();
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                Create.LOGGER.warn("Failed to decode value '{}' from field 'InteractionPoints': {}", (Object)tag, (Object)error.message());
                yield null;
            }
        };
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.writeInteractionPoints(view);
        view.method_71468("Phase", Phase.CODEC, (Object)this.phase);
        view.method_71472("Powered", this.redstoneLocked);
        view.method_71472("Goggles", this.goggles);
        if (!this.heldItem.method_7960()) {
            view.method_71468("HeldItem", class_1799.field_24671, (Object)this.heldItem);
        }
        view.method_71465("TargetPointIndex", this.chasedPointIndex);
        view.method_71464("MovementProgress", this.chasedPointProgress);
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        this.writeInteractionPoints(view);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        class_2499 interactionPointTagBefore = this.interactionPointTag;
        super.read(view, clientPacket);
        this.heldItem = view.method_71426("HeldItem", class_1799.field_24671).orElse(class_1799.field_8037);
        this.phase = view.method_71426("Phase", Phase.CODEC).orElse(Phase.SEARCH_INPUTS);
        this.chasedPointIndex = view.method_71424("TargetPointIndex", 0);
        this.chasedPointProgress = view.method_71423("MovementProgress", 0.0f);
        this.interactionPointTag = view.method_71426("InteractionPoints", CreateCodecs.NBT_LIST_CODEC).orElseGet(class_2499::new);
        this.redstoneLocked = view.method_71433("Powered", false);
        boolean hadGoggles = this.goggles;
        this.goggles = view.method_71433("Goggles", false);
        if (!clientPacket) {
            return;
        }
        if (hadGoggles != this.goggles && this.field_11863.method_8608()) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
        boolean ceiling = this.isOnCeiling();
        if (interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size()) {
            this.updateInteractionPoints = true;
        }
        if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
            ArmInteractionPoint targetedPoint;
            ArmInteractionPoint previousPoint = null;
            if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                previousPoint = this.inputs.get(previousIndex);
            }
            if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                previousPoint = this.outputs.get(previousIndex);
            }
            ArmAngleTarget armAngleTarget = this.previousTarget = previousPoint == null ? ArmAngleTarget.NO_TARGET : previousPoint.getTargetAngles(this.field_11867, ceiling);
            if (previousPoint != null) {
                this.previousBaseAngle = this.previousTarget.baseAngle;
            }
            if ((targetedPoint = this.getTargetedInteractionPoint()) != null) {
                targetedPoint.updateCachedState();
            }
        }
    }

    public static int getRange() {
        return (Integer)AllConfigs.server().logistics.mechanicalArmRange.get();
    }

    public void setLevel(class_1937 level) {
        super.method_31662(level);
        for (ArmInteractionPoint input : this.inputs) {
            input.setLevel(level);
        }
        for (ArmInteractionPoint output : this.outputs) {
            output.setLevel(level);
        }
    }

    public static enum Phase implements class_3542
    {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT,
        DANCING;

        public static final Codec<Phase> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(Phase::values);
        }
    }

    public static enum SelectionMode {
        ROUND_ROBIN,
        FORCED_ROUND_ROBIN,
        PREFER_FIRST;

    }
}

