/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.press;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.foundation.recipe.RecipeApplier;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public class MechanicalPressBlockEntity
extends BasinOperatingBlockEntity
implements PressingBehaviour.PressingBehaviourSpecifics {
    private static final Object compressingRecipesKey = new Object();
    public PressingBehaviour pressingBehaviour;
    private int tracksCreated;

    public MechanicalPressBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_PRESS, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1012(0.0, -1.5, 0.0).method_1012(0.0, 1.0, 0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.pressingBehaviour = new PressingBehaviour(this);
        behaviours.add(this.pressingBehaviour);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PRESS, AllAdvancements.COMPACTING, AllAdvancements.TRACK_CRAFTING);
    }

    public void onItemPressed(class_1799 result) {
        this.award(AllAdvancements.PRESS);
        if (result.method_31573(AllItemTags.TRACKS)) {
            this.tracksCreated += result.method_7947();
        }
        if (this.tracksCreated >= 1000) {
            this.award(AllAdvancements.TRACK_CRAFTING);
            this.tracksCreated = 0;
        }
    }

    public PressingBehaviour getPressingBehaviour() {
        return this.pressingBehaviour;
    }

    @Override
    public boolean tryProcessInBasin(boolean simulate) {
        this.applyBasinRecipe();
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isPresent()) {
            BasinInventory inputs = basin.get().itemCapability;
            for (int slot = 0; slot < 9; ++slot) {
                class_1799 stackInSlot = inputs.method_5438(slot);
                if (stackInSlot.method_7960()) continue;
                this.pressingBehaviour.particleItems.add(stackInSlot);
            }
        }
        return true;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null && behaviour.isOwnerPresent()) {
            view.method_71465("TracksCreated", this.tracksCreated);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.tracksCreated = view.method_71424("TracksCreated", 0);
    }

    @Override
    public boolean tryProcessInWorld(class_1542 itemEntity, boolean simulate) {
        class_1799 item = itemEntity.method_6983();
        class_9696 input = new class_9696(item);
        Optional<class_8786<PressingRecipe>> recipe = this.getRecipe(input);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        class_1799 itemCreated = class_1799.field_8037;
        this.pressingBehaviour.particleItems.add(item);
        if (this.canProcessInBulk() || item.method_7947() == 1) {
            RecipeApplier.applyCreateRecipeOn(itemEntity, input, (CreateRecipe)recipe.get().comp_1933(), true);
            itemCreated = itemEntity.method_6983().method_7972();
        } else {
            for (class_1799 result : RecipeApplier.applyCreateRecipeOn(this.field_11863, 1, input, (CreateRecipe)recipe.get().comp_1933(), true)) {
                if (itemCreated.method_7960()) {
                    itemCreated = result.method_7972();
                }
                class_1542 created = new class_1542(this.field_11863, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), result);
                created.method_6988();
                created.method_18799(VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 0.05f));
                this.field_11863.method_8649((class_1297)created);
            }
            item.method_7934(1);
        }
        if (!itemCreated.method_7960()) {
            this.onItemPressed(itemCreated);
        }
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<class_1799> outputList, boolean simulate) {
        class_9696 recipeInput = new class_9696(input.stack);
        Optional<class_8786<PressingRecipe>> recipe = this.getRecipe(recipeInput);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.pressingBehaviour.particleItems.add(input.stack);
        List<class_1799> outputs = RecipeApplier.applyCreateRecipeOn(this.field_11863, this.canProcessInBulk() ? input.stack.method_7947() : 1, recipeInput, (CreateRecipe)recipe.get().comp_1933(), true);
        for (class_1799 created : outputs) {
            if (created.method_7960()) continue;
            this.onItemPressed(created);
            break;
        }
        outputList.addAll(outputs);
        return true;
    }

    @Override
    public void onPressingCompleted() {
        if (this.pressingBehaviour.onBasin() && this.matchBasinRecipe(this.currentRecipe) && this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isPresent()) {
            this.startProcessingBasin();
        } else {
            this.basinChecker.scheduleUpdate();
        }
    }

    public Optional<class_8786<PressingRecipe>> getRecipe(class_9696 input) {
        return ((class_3218)this.field_11863).method_64577().method_8132(AllRecipeTypes.PRESSING, (class_9695)input, this.field_11863);
    }

    public static boolean canCompress(class_1860<?> recipe) {
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            return MechanicalPressBlockEntity.canCompress(shapedRecipe);
        }
        if (recipe instanceof class_1867) {
            class_1867 shapelessRecipe = (class_1867)recipe;
            return MechanicalPressBlockEntity.canCompress(shapelessRecipe);
        }
        return false;
    }

    public static boolean canCompress(class_1869 recipe) {
        ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
        for (Optional ingredient : recipe.method_61693()) {
            if (ingredient.isPresent()) {
                ingredients.add((class_1856)ingredient.get());
                continue;
            }
            return false;
        }
        int size = ingredients.size();
        if (size != 4 && size != 9) {
            return false;
        }
        return ItemHelper.matchAllIngredients(ingredients);
    }

    public static boolean canCompress(class_1867 recipe) {
        int size = recipe.field_9047.size();
        if (size != 4 && size != 9) {
            return false;
        }
        return ItemHelper.matchAllIngredients(recipe.field_9047);
    }

    @Override
    protected boolean matchStaticFilters(class_8786<? extends class_1860<?>> recipe) {
        class_1860 value = recipe.comp_1933();
        return value instanceof class_3955 && MechanicalPressBlockEntity.canCompress(value) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe) || value.method_17716() == AllRecipeTypes.COMPACTING;
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public boolean canProcessInBulk() {
        return (Boolean)AllConfigs.server().recipes.bulkPressing.get();
    }

    @Override
    protected Object getRecipeCacheKey() {
        return compressingRecipesKey;
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    @Override
    public void startProcessingBasin() {
        if (this.pressingBehaviour.running && this.pressingBehaviour.runningTicks <= 120) {
            return;
        }
        super.startProcessingBasin();
        this.pressingBehaviour.start(PressingBehaviour.Mode.BASIN);
    }

    @Override
    protected void onBasinRemoved() {
        this.pressingBehaviour.particleItems.clear();
        this.pressingBehaviour.running = false;
        this.pressingBehaviour.runningTicks = 0;
        this.sendData();
    }

    @Override
    protected boolean isRunning() {
        return this.pressingBehaviour.running;
    }

    @Override
    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.COMPACTING);
    }
}

