/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.press;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.press.BeltPressingCallbacks;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public class PressingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 240;
    public static final int ENTITY_SCAN = 10;
    public List<class_1799> particleItems = new ArrayList<class_1799>();
    public PressingBehaviourSpecifics specifics;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    public Mode mode;
    int entityScanCooldown;

    public <T extends SmartBlockEntity> PressingBehaviour(T be) {
        super(be);
        this.specifics = (PressingBehaviourSpecifics)((Object)be);
        this.mode = Mode.WORLD;
        this.entityScanCooldown = 10;
        this.whenItemEnters((s, i) -> BeltPressingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltPressingCallbacks.whenItemHeld(s, i, this));
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        this.running = view.method_71433("Running", false);
        this.mode = Mode.values()[view.method_71424("Mode", 0)];
        this.finished = view.method_71433("Finished", false);
        this.prevRunningTicks = this.runningTicks = view.method_71424("Ticks", 0);
        super.read(view, clientPacket);
        if (clientPacket) {
            view.method_71426("ParticleItems", CreateCodecs.ITEM_LIST_CODEC).ifPresent(this.particleItems::addAll);
            this.spawnParticles();
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Running", this.running);
        view.method_71465("Mode", this.mode.ordinal());
        view.method_71472("Finished", this.finished);
        view.method_71465("Ticks", this.runningTicks);
        super.write(view, clientPacket);
        if (clientPacket) {
            view.method_71468("ParticleItems", CreateCodecs.ITEM_LIST_CODEC, this.particleItems);
            this.particleItems.clear();
        }
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = class_3532.method_48781((float)partialTicks, (int)this.prevRunningTicks, (int)runningTicks);
        if (runningTicks < 160) {
            return (float)class_3532.method_15350((double)Math.pow(ticks / 240.0f * 2.0f, 3.0), (double)0.0, (double)1.0);
        }
        return class_3532.method_15363((float)((240.0f - ticks) / 240.0f * 3.0f), (float)0.0f, (float)1.0f);
    }

    public void start(Mode mode) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.particleItems.clear();
        this.blockEntity.sendData();
    }

    public boolean inWorld() {
        return this.mode == Mode.WORLD;
    }

    public boolean onBasin() {
        return this.mode == Mode.BASIN;
    }

    @Override
    public void tick() {
        super.tick();
        class_1937 level = this.getWorld();
        class_2338 worldPosition = this.getPos();
        if (!this.running || level == null) {
            if (level != null && !level.method_8608()) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (BlockEntityBehaviour.get((class_1922)level, worldPosition.method_10087(2), TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    if (BasinBlock.isBasin((class_4538)level, worldPosition.method_10087(2))) {
                        return;
                    }
                    for (class_1542 itemEntity : level.method_18467(class_1542.class, new class_238(worldPosition.method_10074()).method_1011(0.125))) {
                        if (!itemEntity.method_5805() || !itemEntity.method_24828() || !this.specifics.tryProcessInWorld(itemEntity, true)) continue;
                        this.start(Mode.WORLD);
                        return;
                    }
                }
            }
            return;
        }
        if (level.method_8608() && this.runningTicks == -120) {
            this.prevRunningTicks = 120;
            return;
        }
        if (this.runningTicks == 120 && this.specifics.getKineticSpeed() != 0.0f) {
            if (this.inWorld()) {
                this.applyInWorld();
            }
            if (this.onBasin()) {
                this.applyOnBasin();
            }
            if (level.method_8320(worldPosition.method_10087(2)).method_26231() == class_2498.field_11543) {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(level, (class_2382)worldPosition);
            } else {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(level, (class_2382)worldPosition, 0.5f, 0.75f + Math.abs(this.specifics.getKineticSpeed()) / 1024.0f);
            }
            if (!level.method_8608()) {
                this.blockEntity.sendData();
            }
        }
        if (!level.method_8608() && this.runningTicks > 240) {
            this.finished = true;
            this.running = false;
            this.particleItems.clear();
            this.specifics.onPressingCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 120 && this.runningTicks >= 120) {
            this.runningTicks = 120;
            if (level.method_8608() && !this.blockEntity.isVirtual()) {
                this.runningTicks = -120;
            }
        }
    }

    protected void applyOnBasin() {
        class_1937 level = this.getWorld();
        if (level.method_8608()) {
            return;
        }
        this.particleItems.clear();
        if (this.specifics.tryProcessInBasin(false)) {
            this.blockEntity.sendData();
        }
    }

    protected void applyInWorld() {
        class_1937 level = this.getWorld();
        class_2338 worldPosition = this.getPos();
        class_238 bb = new class_238(worldPosition.method_10087(1));
        boolean bulk = this.specifics.canProcessInBulk();
        this.particleItems.clear();
        if (level.method_8608()) {
            return;
        }
        for (class_1297 entity : level.method_8335(null, bb)) {
            if (!(entity instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity;
            if (!entity.method_5805() || !entity.method_24828()) continue;
            this.entityScanCooldown = 0;
            if (this.specifics.tryProcessInWorld(itemEntity, false)) {
                this.blockEntity.sendData();
            }
            if (bulk) continue;
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return class_3532.method_48781((float)class_3532.method_15363((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (int)1, (int)60);
    }

    protected void spawnParticles() {
        if (this.particleItems.isEmpty()) {
            return;
        }
        class_2338 worldPosition = this.getPos();
        if (this.mode == Mode.BASIN) {
            this.particleItems.forEach(stack -> this.makeCompactingParticleEffect(VecHelper.getCenterOf((class_2382)worldPosition.method_10087(2)), (class_1799)stack));
        }
        if (this.mode == Mode.BELT) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((class_2382)worldPosition.method_10087(2)).method_1031(0.0, 0.5, 0.0), (class_1799)stack));
        }
        if (this.mode == Mode.WORLD) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((class_2382)worldPosition.method_10087(1)).method_1031(0.0, -0.25, 0.0), (class_1799)stack));
        }
        this.particleItems.clear();
    }

    public void makePressingParticleEffect(class_243 pos, class_1799 stack) {
        this.makePressingParticleEffect(pos, stack, this.specifics.getParticleAmount());
    }

    public void makePressingParticleEffect(class_243 pos, class_1799 stack, int amount) {
        class_1937 level = this.getWorld();
        if (level == null || !level.method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, 0.125f).method_18805(1.0, 0.0, 1.0);
            motion = motion.method_1031(0.0, amount != 1 ? 0.125 : 0.0625, 0.0);
            level.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), pos.field_1352, pos.field_1351 - 0.25, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
    }

    public void makeCompactingParticleEffect(class_243 pos, class_1799 stack) {
        class_1937 level = this.getWorld();
        if (level == null || !level.method_8608()) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, 0.175f).method_18805(1.0, 0.0, 1.0);
            level.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351 + 0.25, motion.field_1350);
        }
    }

    public static interface PressingBehaviourSpecifics {
        public boolean tryProcessInBasin(boolean var1);

        public boolean tryProcessOnBelt(TransportedItemStack var1, List<class_1799> var2, boolean var3);

        public boolean tryProcessInWorld(class_1542 var1, boolean var2);

        public boolean canProcessInBulk();

        public void onPressingCompleted();

        public int getParticleAmount();

        public float getKineticSpeed();
    }

    public static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f),
        BASIN(1.375f);

        public float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }
}

