/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public record ItemNameAttribute(String itemName) implements ItemAttribute
{
    public static final MapCodec<ItemNameAttribute> CODEC = Codec.STRING.xmap(ItemNameAttribute::new, ItemNameAttribute::itemName).fieldOf("value");
    public static final class_9139<ByteBuf, ItemNameAttribute> PACKET_CODEC = class_9135.field_48554.method_56432(ItemNameAttribute::new, ItemNameAttribute::itemName);

    private static String extractCustomName(class_1799 stack, class_1937 level) {
        if (stack.method_57826(class_9334.field_49631)) {
            try {
                String customName = ((class_2561)stack.method_58695(class_9334.field_49631, (Object)class_2561.method_43473())).getString();
                Optional component = class_8824.field_46597.parse((DynamicOps)level.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)JsonParser.parseString((String)(customName.isEmpty() ? "\"\"" : customName))).result();
                if (component.isPresent()) {
                    return ((class_2561)component.get()).getString();
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return ItemNameAttribute.extractCustomName(itemStack, level).equals(this.itemName);
    }

    @Override
    public String getTranslationKey() {
        return "has_name";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.itemName};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_NAME;
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemNameAttribute("dummy");
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            String name = ItemNameAttribute.extractCustomName(stack, level);
            if (!name.isEmpty()) {
                list.add(new ItemNameAttribute(name));
            }
            return list;
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}

