/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagePort.frogport;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.audio.FrogportAudioBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class FrogportBlockEntity
extends PackagePortBlockEntity {
    public class_1799 animatedPackage;
    public LerpedFloat manualOpenAnimationProgress;
    public LerpedFloat animationProgress = LerpedFloat.linear();
    public LerpedFloat anticipationProgress = LerpedFloat.linear();
    public boolean currentlyDepositing;
    public boolean goggles = false;
    public boolean sendAnticipate;
    public float passiveYaw;
    public boolean failedLastExport;
    private class_1799 deferAnimationStart;
    private boolean deferAnimationInward;

    public FrogportBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.PACKAGE_FROGPORT, pos, state);
        this.manualOpenAnimationProgress = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.35, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FROGPORT);
    }

    public boolean isAnimationInProgress() {
        return this.animationProgress.getChaseTarget() == 1.0f;
    }

    @Override
    public class_238 getRenderBoundingBox() {
        class_238 bb = super.getRenderBoundingBox().method_1012(0.0, 1.0, 0.0);
        if (this.target != null) {
            bb = bb.method_991(new class_238(class_2338.method_49638((class_2374)this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867)))).method_1014(0.5);
        }
        return bb;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608() || this.isAnimationInProgress()) {
            return;
        }
        boolean prevFail = this.failedLastExport;
        this.tryPushingToAdjacentInventories();
        this.tryPullingFromOwnAndAdjacentInventories();
        if (this.failedLastExport != prevFail) {
            this.sendData();
        }
    }

    public void sendAnticipate() {
        if (this.isAnimationInProgress()) {
            return;
        }
        int size = this.inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            if (!this.inventory.method_5438(i).method_7960()) continue;
            this.sendAnticipate = true;
            this.sendData();
            return;
        }
    }

    public void anticipate() {
        this.anticipationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.deferAnimationStart != null) {
            this.startAnimation(this.deferAnimationStart, this.deferAnimationInward);
            this.deferAnimationStart = null;
        }
        if (this.anticipationProgress.getValue() == 1.0f) {
            this.anticipationProgress.startWithValue(0.0);
        }
        this.manualOpenAnimationProgress.updateChaseTarget(this.openTracker.openCount > 0 ? 1.0f : 0.0f);
        boolean wasOpen = this.manualOpenAnimationProgress.getValue() > 0.0f;
        this.anticipationProgress.tickChaser();
        this.manualOpenAnimationProgress.tickChaser();
        if (this.field_11863.method_8608() && wasOpen && this.manualOpenAnimationProgress.getValue() == 0.0f) {
            this.getBehaviour(FrogportAudioBehaviour.TYPE).close(this.field_11863, this.field_11867);
        }
        if (!this.isAnimationInProgress()) {
            return;
        }
        this.animationProgress.tickChaser();
        float value = this.animationProgress.getValue();
        if (this.currentlyDepositing) {
            if (!this.field_11863.method_8608() || this.isVirtual()) {
                if ((double)value > 0.5 && this.animatedPackage != null) {
                    if (this.target == null || !this.target.depositImmediately() && !this.target.export((class_1936)this.field_11863, this.field_11867, this.animatedPackage, false)) {
                        this.drop(this.animatedPackage);
                    }
                    this.animatedPackage = null;
                }
            } else {
                if ((double)value > 0.7 && this.animatedPackage != null) {
                    this.animatedPackage = null;
                }
                if ((double)this.animationProgress.getValue(0.0f) < 0.2 && (double)value > 0.2) {
                    class_243 v = this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867);
                    this.field_11863.method_8486(v.field_1352, v.field_1351, v.field_1350, class_3417.field_24064, class_3419.field_15245, 0.25f, 1.2f, false);
                }
            }
        }
        if (value < 1.0f) {
            return;
        }
        this.anticipationProgress.startWithValue(0.0);
        this.animationProgress.startWithValue(0.0);
        if (this.field_11863.method_8608()) {
            this.animatedPackage = null;
            return;
        }
        if (!this.currentlyDepositing) {
            int count = this.animatedPackage.method_7947();
            this.inventory.sendMode();
            int insert = this.inventory.insert(this.animatedPackage, count);
            this.inventory.receiveMode();
            if (insert != count) {
                if (insert == 0) {
                    this.drop(this.animatedPackage);
                } else {
                    this.drop(this.animatedPackage.method_46651(count - insert));
                }
            }
        }
        this.animatedPackage = null;
    }

    public void startAnimation(class_1799 box, boolean deposit) {
        if (!PackageItem.isPackage(box)) {
            return;
        }
        if (deposit && (this.target == null || this.target.depositImmediately() && !this.target.export((class_1936)this.field_11863, this.field_11867, box.method_7972(), false))) {
            return;
        }
        this.animationProgress.startWithValue(0.0);
        this.animationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
        this.animatedPackage = box;
        this.currentlyDepositing = deposit;
        if (this.field_11863 != null && !deposit && !this.field_11863.method_8608()) {
            this.award(AllAdvancements.FROGPORT);
        }
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            FrogportAudioBehaviour sounds = this.getBehaviour(FrogportAudioBehaviour.TYPE);
            sounds.open(this.field_11863, this.field_11867);
            if (this.currentlyDepositing) {
                sounds.depositPackage(this.field_11863, this.field_11867);
            } else {
                sounds.catchPackage(this.field_11863, this.field_11867);
                class_243 vec = this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867);
                if (vec != null) {
                    for (int i = 0; i < 5; ++i) {
                        this.field_11863.method_8406((class_2394)new class_2388(class_2398.field_11217, AllBlocks.ROPE.method_9564()), vec.field_1352, vec.field_1351 - (double)this.field_11863.field_9229.method_43057() * 0.25, vec.field_1350, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8524(this.field_11867);
            this.sendData();
        }
    }

    protected void tryPushingToAdjacentInventories() {
        this.failedLastExport = false;
        if (this.inventory.method_5442()) {
            return;
        }
        class_1263 handler = this.getAdjacentInventory(class_2350.field_11033);
        if (handler == null) {
            return;
        }
        boolean dirty = false;
        int size = this.inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (stack.method_7960() || !this.inventory.method_5493(i, stack, null)) continue;
            int insert = handler.insertExist(stack, 1);
            if (insert == 1) {
                int count = stack.method_7947();
                if (count == 1) {
                    this.inventory.method_5447(i, class_1799.field_8037);
                } else {
                    stack.method_7939(count - 1);
                }
                dirty = true;
                continue;
            }
            this.failedLastExport = true;
        }
        if (dirty) {
            this.inventory.method_5431();
            this.field_11863.method_8524(this.field_11867);
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
    }

    public void tryPullingFromOwnAndAdjacentInventories() {
        if (this.isAnimationInProgress()) {
            return;
        }
        if (this.target == null || !this.target.export((class_1936)this.field_11863, this.field_11867, PackageStyles.getDefaultBox(), true)) {
            return;
        }
        this.inventory.sendMode();
        class_1799 stack = this.inventory.extractAny();
        this.inventory.receiveMode();
        if (!stack.method_7960()) {
            this.startAnimation(stack, true);
            return;
        }
        for (class_2350 side : Iterate.directions) {
            class_1263 handler;
            if (side != class_2350.field_11033 || (handler = this.getAdjacentInventory(side)) == null || !this.tryPullingFrom(handler)) continue;
            return;
        }
    }

    public boolean tryPullingFrom(class_1263 handler) {
        class_1799 extract = handler.extract(stack -> {
            if (!PackageItem.isPackage(stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || handler instanceof PackagerItemHandler || !PackageItem.matchAddress(stack, filterString);
        });
        if (extract.method_7960()) {
            return false;
        }
        this.startAnimation(extract, true);
        return true;
    }

    protected class_1263 getAdjacentInventory(class_2350 side) {
        class_2338 pos = this.field_11867.method_10093(side);
        class_2586 blockEntity = this.field_11863.method_8321(pos);
        if (blockEntity == null || blockEntity instanceof FrogportBlockEntity) {
            return null;
        }
        return ItemHelper.getInventory(this.field_11863, pos, null, blockEntity, side.method_10153());
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71464("PlacedYaw", this.passiveYaw);
        if (this.animatedPackage != null && this.isAnimationInProgress()) {
            view.method_71468("AnimatedPackage", class_1799.field_24671, (Object)this.animatedPackage);
            view.method_71472("Deposit", this.currentlyDepositing);
        }
        if (this.sendAnticipate) {
            this.sendAnticipate = false;
            view.method_71472("Anticipate", true);
        }
        if (this.failedLastExport) {
            view.method_71472("FailedLastExport", true);
        }
        if (this.goggles) {
            view.method_71472("Goggles", true);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.passiveYaw = view.method_71423("PlacedYaw", 0.0f);
        this.failedLastExport = view.method_71433("FailedLastExport", false);
        this.goggles = view.method_71433("Goggles", false);
        if (!clientPacket) {
            this.animatedPackage = null;
        }
        view.method_71426("AnimatedPackage", class_1799.field_24671).ifPresent(stack -> {
            this.deferAnimationInward = view.method_71433("Deposit", false);
            this.deferAnimationStart = stack;
        });
        if (clientPacket && view.method_71433("Anticipate", false)) {
            this.anticipate();
        }
    }

    public float getYaw() {
        if (this.target == null) {
            return this.passiveYaw;
        }
        class_243 diff = this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867).method_1020(class_243.method_24953((class_2382)this.field_11867));
        return (float)(class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350) * 57.2957763671875) + 180.0f;
    }

    @Override
    protected void onOpenedManually() {
        if (this.field_11863.method_8608()) {
            this.getBehaviour(FrogportAudioBehaviour.TYPE).open(this.field_11863, this.field_11867);
        }
    }

    @Override
    public class_1269 use(class_1657 player) {
        class_1799 mainHandItem;
        if (player == null) {
            return class_1269.field_52423;
        }
        if (!this.goggles && (mainHandItem = player.method_6047()).method_31574((class_1792)AllItems.GOGGLES)) {
            this.goggles = true;
            if (!this.field_11863.method_8608()) {
                this.notifyUpdate();
                this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_14761.comp_349(), class_3419.field_15245, 0.5f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return super.use(player);
    }
}

