/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.diodes;

import com.mojang.serialization.Codec;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerBrassDiodeScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public abstract class BrassDiodeBlockEntity
extends SmartBlockEntity
implements ClipboardCloneable {
    public int state;
    ServerScrollValueBehaviour maxState;

    public BrassDiodeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.maxState = new ServerBrassDiodeScrollValueBehaviour(this).between(2, 72000);
        this.maxState.withCallback(this::onMaxDelayChanged);
        this.maxState.setValue(this.defaultValue());
        behaviours.add(this.maxState);
    }

    protected int defaultValue() {
        return 2;
    }

    public float getProgress() {
        int max = Math.max(2, this.maxState.getValue());
        return (float)class_3532.method_15340((int)this.state, (int)0, (int)max) / (float)max;
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public void tick() {
        super.tick();
        boolean powered = (Boolean)this.method_11010().method_11654((class_2769)class_2312.field_10911);
        boolean powering = (Boolean)this.method_11010().method_11654((class_2769)BrassDiodeBlock.POWERING);
        boolean atMax = this.state >= this.maxState.getValue();
        boolean atMin = this.state <= 0;
        this.updateState(powered, powering, atMax, atMin);
    }

    protected abstract void updateState(boolean var1, boolean var2, boolean var3, boolean var4);

    private void onMaxDelayChanged(int newMax) {
        this.state = class_3532.method_15340((int)this.state, (int)0, (int)newMax);
        this.sendData();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.state = view.method_71424("State", 0);
        super.read(view, clientPacket);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("State", this.state);
        super.write(view, clientPacket);
    }

    @Override
    public String getClipboardKey() {
        return "Block";
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        Optional inverted = view.method_71426("Inverted", (Codec)Codec.BOOL);
        if (inverted.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        class_2680 blockState = this.method_11010();
        if (blockState.method_11654((class_2769)BrassDiodeBlock.INVERTED) != inverted.get()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_28493((class_2769)BrassDiodeBlock.INVERTED));
        }
        return true;
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        view.method_71468("Inverted", (Codec)Codec.BOOL, (Object)((Boolean)this.method_11010().method_61767((class_2769)BrassDiodeBlock.INVERTED, (Comparable)Boolean.valueOf(false))));
        return true;
    }
}

