/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.BogeySize;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class CarriageBogey {
    public static final class_9139<class_9129, CarriageBogey> STREAM_CODEC = class_9139.method_56436(AbstractBogeyBlock.STREAM_CODEC, bogey -> bogey.type, (class_9139)class_9135.field_48547, bogey -> bogey.upsideDown, (class_9139)class_9135.field_48556, bogey -> bogey.bogeyData, CarriageBogey::new);
    public static final Random RANDOM = new Random();
    public static final String UPSIDE_DOWN_KEY = "UpsideDown";
    public Carriage carriage;
    public boolean isLeading;
    public class_2487 bogeyData;
    public AbstractBogeyBlock<?> type;
    boolean upsideDown;
    Couple<TravellingPoint> points;
    public LerpedFloat wheelAngle;
    public LerpedFloat yaw;
    public LerpedFloat pitch;
    public Couple<class_243> couplingAnchors;
    int derailAngle;

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, class_2487 bogeyData) {
        this(type, upsideDown, bogeyData, new TravellingPoint(), new TravellingPoint());
    }

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, class_2487 bogeyData, TravellingPoint point, TravellingPoint point2) {
        this.type = type;
        point.upsideDown = this.upsideDown = type.canBeUpsideDown() && upsideDown;
        point2.upsideDown = this.upsideDown;
        if (bogeyData == null || bogeyData.method_33133()) {
            bogeyData = this.createBogeyData();
        }
        bogeyData.method_10556(UPSIDE_DOWN_KEY, upsideDown);
        this.bogeyData = bogeyData;
        this.points = Couple.create(point, point2);
        this.wheelAngle = LerpedFloat.angular();
        this.yaw = LerpedFloat.angular();
        this.pitch = LerpedFloat.angular();
        this.derailAngle = RANDOM.nextInt(60) - 30;
        this.couplingAnchors = Couple.create(null, null);
    }

    public class_5321<class_1937> getDimension() {
        TravellingPoint leading = this.leading();
        TravellingPoint trailing = this.trailing();
        if (leading.edge == null || trailing.edge == null) {
            return null;
        }
        if (leading.edge.isInterDimensional() || trailing.edge.isInterDimensional()) {
            return null;
        }
        class_5321<class_1937> dimension1 = leading.node1.getLocation().dimension;
        class_5321<class_1937> dimension2 = trailing.node1.getLocation().dimension;
        if (dimension1.equals(dimension2)) {
            return dimension1;
        }
        return null;
    }

    public void updateAngles(CarriageContraptionEntity entity, double distanceMoved) {
        double angleDiff = 360.0 * distanceMoved / (Math.PI * 2 * this.type.getWheelRadius());
        float xRot = 0.0f;
        float yRot = 0.0f;
        if (this.leading().edge == null || this.carriage.train.derailed) {
            yRot = -90.0f + entity.yaw - (float)this.derailAngle;
        } else if (!entity.method_73183().method_27983().equals(this.getDimension())) {
            yRot = -90.0f + entity.yaw;
            xRot = 0.0f;
        } else {
            class_243 positionVec = this.leading().getPosition(this.carriage.train.graph);
            class_243 coupledVec = this.trailing().getPosition(this.carriage.train.graph);
            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;
            yRot = AngleHelper.deg(class_3532.method_15349((double)diffZ, (double)diffX)) + 90.0f;
            xRot = AngleHelper.deg(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));
        }
        double newWheelAngle = ((double)this.wheelAngle.getValue() - angleDiff) % 360.0;
        for (boolean twice : Iterate.trueAndFalse) {
            if (twice && !entity.firstPositionUpdate) continue;
            this.wheelAngle.setValue(newWheelAngle);
            this.pitch.setValue(xRot);
            this.yaw.setValue(-yRot);
        }
    }

    public TravellingPoint leading() {
        TravellingPoint point = (TravellingPoint)this.points.getFirst();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public TravellingPoint trailing() {
        TravellingPoint point = (TravellingPoint)this.points.getSecond();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public double getStress() {
        if (this.getDimension() == null) {
            return 0.0;
        }
        if (this.carriage.train.derailed) {
            return 0.0;
        }
        return this.type.getWheelPointSpacing() - this.leading().getPosition(this.carriage.train.graph).method_1022(this.trailing().getPosition(this.carriage.train.graph));
    }

    @Nullable
    public class_243 getAnchorPosition() {
        return this.getAnchorPosition(false);
    }

    @Nullable
    public class_243 getAnchorPosition(boolean flipUpsideDown) {
        if (this.leading().edge == null) {
            return null;
        }
        return ((TravellingPoint)this.points.getFirst()).getPosition(this.carriage.train.graph, flipUpsideDown).method_1019(((TravellingPoint)this.points.getSecond()).getPosition(this.carriage.train.graph, flipUpsideDown)).method_1021(0.5);
    }

    public void updateCouplingAnchor(class_243 entityPos, float entityXRot, float entityYRot, int bogeySpacing, float yaw, float pitch, boolean leading) {
        boolean selfUpsideDown = this.isUpsideDown();
        boolean leadingUpsideDown = this.carriage.leadingBogey().isUpsideDown();
        class_243 thisOffset = this.type.getConnectorAnchorOffset(selfUpsideDown);
        thisOffset = thisOffset.method_18805(1.0, 1.0, leading ? -1.0 : 1.0);
        thisOffset = VecHelper.rotate(thisOffset, pitch, class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, yaw, class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityYRot - 90.0f, class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, entityXRot, class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, -180.0, class_2350.class_2351.field_11052);
        thisOffset = thisOffset.method_1031(0.0, 0.0, leading ? 0.0 : (double)(-bogeySpacing));
        thisOffset = VecHelper.rotate(thisOffset, 180.0, class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityXRot, class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, entityYRot + 90.0f, class_2350.class_2351.field_11052);
        if (selfUpsideDown != leadingUpsideDown) {
            thisOffset = thisOffset.method_1031(0.0, selfUpsideDown ? -2.0 : 2.0, 0.0);
        }
        this.couplingAnchors.set(leading, entityPos.method_1019(thisOffset));
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Type", CreateCodecs.BLOCK_CODEC, this.type);
        class_11372.class_11374 list = view.method_71476("Points");
        ((TravellingPoint)this.points.getFirst()).write(list.method_71480(), dimensions);
        ((TravellingPoint)this.points.getSecond()).write(list.method_71480(), dimensions);
        view.method_71472(UPSIDE_DOWN_KEY, this.upsideDown);
        this.bogeyData.method_10556(UPSIDE_DOWN_KEY, this.upsideDown);
        this.bogeyData.method_67494("BogeyStyle", class_2960.field_25139, (Object)this.getStyle().id);
        view.method_71468("BogeyData", class_2487.field_25128, (Object)this.bogeyData);
    }

    public static <T> DataResult<T> encode(CarriageBogey input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Type", input.type, CreateCodecs.BLOCK_CODEC);
        ListBuilder list = ops.listBuilder();
        list.add(TravellingPoint.encode((TravellingPoint)input.points.getFirst(), ops, empty, dimensions));
        list.add(TravellingPoint.encode((TravellingPoint)input.points.getSecond(), ops, empty, dimensions));
        map.add("Points", list.build(empty));
        map.add(UPSIDE_DOWN_KEY, ops.createBoolean(input.upsideDown));
        input.bogeyData.method_10556(UPSIDE_DOWN_KEY, input.upsideDown);
        input.bogeyData.method_67494("BogeyStyle", class_2960.field_25139, (Object)input.getStyle().id);
        map.add("BogeyData", (Object)input.bogeyData, (Encoder)class_2487.field_25128);
        return map.build(empty);
    }

    public static CarriageBogey read(class_11368 view, TrackGraph graph, DimensionPalette dimensions) {
        AbstractBogeyBlock type = (AbstractBogeyBlock)view.method_71426("Type", CreateCodecs.BLOCK_CODEC).orElseThrow();
        boolean upsideDown = view.method_71433(UPSIDE_DOWN_KEY, false);
        Iterator iterator = view.method_71438("Points").iterator();
        TravellingPoint point1 = TravellingPoint.read((class_11368)iterator.next(), graph, dimensions);
        TravellingPoint point2 = TravellingPoint.read((class_11368)iterator.next(), graph, dimensions);
        class_2487 data = (class_2487)view.method_71426("BogeyData", class_2487.field_25128).orElseThrow();
        return new CarriageBogey(type, upsideDown, data, point1, point2);
    }

    public static <T> CarriageBogey decode(DynamicOps<T> ops, T input, TrackGraph graph, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        AbstractBogeyBlock type = (AbstractBogeyBlock)CreateCodecs.BLOCK_CODEC.parse(ops, map.get("Type")).getOrThrow();
        boolean upsideDown = (Boolean)ops.getBooleanValue(map.get(UPSIDE_DOWN_KEY)).getOrThrow();
        Iterator iterator = ((Stream)ops.getStream(map.get("Points")).getOrThrow()).iterator();
        TravellingPoint point1 = TravellingPoint.decode(ops, iterator.next(), graph, dimensions);
        TravellingPoint point2 = TravellingPoint.decode(ops, iterator.next(), graph, dimensions);
        class_2487 data = (class_2487)class_2487.field_25128.parse(ops, map.get("BogeyData")).getOrThrow();
        return new CarriageBogey(type, upsideDown, data, point1, point2);
    }

    public BogeyStyle getStyle() {
        Optional location = this.bogeyData.method_67491("BogeyStyle", class_2960.field_25139);
        if (location.isEmpty()) {
            return AllBogeyStyles.STANDARD;
        }
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(location.get());
        return style != null ? style : AllBogeyStyles.STANDARD;
    }

    public BogeySize getSize() {
        return this.type.getSize();
    }

    private class_2487 createBogeyData() {
        BogeyStyle style = this.type != null ? this.type.getDefaultStyle() : AllBogeyStyles.STANDARD;
        class_2487 nbt = style.defaultData != null ? style.defaultData : new class_2487();
        nbt.method_67494("BogeyStyle", class_2960.field_25139, (Object)style.id);
        nbt.method_10556(UPSIDE_DOWN_KEY, this.isUpsideDown());
        return nbt;
    }

    void setLeading() {
        this.isLeading = true;
    }

    public boolean isUpsideDown() {
        return this.type.canBeUpsideDown() && this.upsideDown;
    }
}

