/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public abstract class TimedWaitCondition
extends ScheduleWaitCondition {
    protected void requestDisplayIfNecessary(class_2487 context, int time) {
        int ticksUntilDeparture = this.totalWaitTicks() - time;
        if (ticksUntilDeparture < 1200 && ticksUntilDeparture % 100 == 0) {
            this.requestStatusToUpdate(context);
        }
        if (ticksUntilDeparture >= 1200 && ticksUntilDeparture % 1200 == 0) {
            this.requestStatusToUpdate(context);
        }
    }

    public int totalWaitTicks() {
        return this.getValue() * this.getUnit().ticksPer;
    }

    public TimedWaitCondition(class_2960 id) {
        super(id);
        this.data.method_10569("Value", 5);
        this.data.method_10569("TimeUnit", TimeUnit.SECONDS.ordinal());
    }

    public int getValue() {
        return this.intData("Value");
    }

    public TimeUnit getUnit() {
        return this.enumData("TimeUnit", TimeUnit.class);
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int time = tag.method_68083("Time", 0);
        int ticksUntilDeparture = this.totalWaitTicks() - time;
        boolean showInMinutes = ticksUntilDeparture >= 1200;
        int num = (int)(showInMinutes ? Math.floor((float)ticksUntilDeparture / 1200.0f) : Math.ceil((float)ticksUntilDeparture / 100.0f) * 5.0);
        String key = "generic." + (showInMinutes ? (num == 1 ? "daytime.minute" : "unit.minutes") : (num == 1 ? "daytime.second" : "unit.seconds"));
        return class_2561.method_43469((String)("create.schedule.condition." + this.id.method_12832() + ".status"), (Object[])new Object[]{class_2561.method_43470((String)(num + " ")).method_10852((class_2561)class_2561.method_43471((String)("create." + key)))});
    }

    public static enum TimeUnit {
        TICKS(1, "t"),
        SECONDS(20, "s"),
        MINUTES(1200, "min");

        public final int ticksPer;
        public final String suffix;

        private TimeUnit(int ticksPer, String suffix) {
            this.ticksPer = ticksPer;
            this.suffix = suffix;
        }
    }
}

