/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraphHelper;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableObject;

public class TrackTargetingBlockItem
extends class_1747 {
    private final EdgePointType<?> type;

    public TrackTargetingBlockItem(class_2248 pBlock, class_1792.class_1793 pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties);
        this.type = type;
    }

    public static TrackTargetingBlockItem station(class_2248 pBlock, class_1792.class_1793 pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.STATION);
    }

    public static TrackTargetingBlockItem signal(class_2248 pBlock, class_1792.class_1793 pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.SIGNAL);
    }

    public static TrackTargetingBlockItem observer(class_2248 pBlock, class_1792.class_1793 pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.OBSERVER);
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1799 stack = pContext.method_8041();
        class_2338 pos = pContext.method_8037();
        class_1937 level = pContext.method_8045();
        class_2680 state = level.method_8320(pos);
        class_1657 player = pContext.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        if (player.method_5715() && stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"create.track_target.clear"), true);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)pos, 1.0f, 0.5f);
            return class_1269.field_5812;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)class_22482;
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            class_243 lookAngle = player.method_5720();
            boolean front = track.getNearestTrackAxis((class_1922)level, pos, state, lookAngle).getSecond() == class_2350.class_2352.field_11056;
            EdgePointType<?> type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            TrackTargetingBlockItem.withGraphLocation(level, pos, front, null, type, (overlap, location) -> result.setValue((Object)overlap));
            if (((OverlapResult)((Object)result.getValue())).feedback != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)("create." + ((OverlapResult)((Object)result.getValue())).feedback)).method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.play(level, null, (class_2382)pos, 0.5f, 1.0f);
                return class_1269.field_5814;
            }
            stack.method_57379(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS, (Object)pos);
            stack.method_57379(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)front);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            player.method_7353((class_2561)class_2561.method_43471((String)"create.track_target.set"), true);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)pos, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (!stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.track_target.missing").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        class_2487 blockEntityData = new class_2487();
        blockEntityData.method_10556("TargetDirection", ((Boolean)stack.method_58695(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)false)).booleanValue());
        class_2338 selectedPos = (class_2338)stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        class_2338 placedPos = pos.method_10079(pContext.method_8038(), state.method_45474() ? 0 : 1);
        boolean bezier = stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
        if (!selectedPos.method_19771((class_2382)placedPos, bezier ? (double)((Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() + 16) : 16.0)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.track_target.too_far").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        if (bezier) {
            BezierTrackPointLocation bezierTrackPointLocation = (BezierTrackPointLocation)stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            class_2487 bezierNbt = new class_2487();
            bezierNbt.method_10569("Segment", bezierTrackPointLocation.segment());
            bezierNbt.method_67494("Key", class_2338.field_25064, (Object)bezierTrackPointLocation.curveTarget().method_10059((class_2382)placedPos));
            blockEntityData.method_10566("Bezier", (class_2520)bezierNbt);
        }
        blockEntityData.method_67494("TargetTrack", class_2338.field_25064, (Object)selectedPos.method_10059((class_2382)placedPos));
        stack.method_57379(class_9334.field_49611, (Object)class_11580.method_72535(((IBE)this.method_7711()).getBlockEntityType(), (class_2487)blockEntityData));
        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
        class_1269 useOn = super.method_7884(pContext);
        stack.method_57381(class_9334.field_49611);
        if (level.method_8608() || useOn == class_1269.field_5814) {
            return useOn;
        }
        class_1799 itemInHand = player.method_5998(pContext.method_20287());
        if (!itemInHand.method_7960()) {
            itemInHand.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
            itemInHand.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
            itemInHand.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"create.track_target.success").method_27692(class_124.field_1060), true);
        if (this.type == EdgePointType.SIGNAL) {
            AllAdvancements.SIGNAL.trigger((class_3222)player);
        }
        return useOn;
    }

    public EdgePointType<?> getType(class_1799 stack) {
        return this.type;
    }

    public static void withGraphLocation(class_1937 level, class_2338 pos, boolean front, BezierTrackPointLocation targetBezier, EdgePointType<?> type, BiConsumer<OverlapResult, TrackGraphLocation> callback) {
        TrackGraphLocation location;
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        List<class_243> trackAxes = track.getTrackAxes((class_1922)level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(OverlapResult.JUNCTION, null);
            return;
        }
        class_2350.class_2352 targetDirection = front ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        TrackGraphLocation trackGraphLocation = location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.getFirst());
        if (location == null) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        Couple<TrackNode> nodes = location.edge.map(location.graph::locateNode);
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        EdgeData edgeData = edge.getEdgeData();
        double edgePosition = location.position;
        for (TrackEdgePoint edgePoint : edgeData.getPoints()) {
            double otherEdgePosition = edgePoint.getLocationOn(edge);
            double distance = Math.abs(edgePosition - otherEdgePosition);
            if (distance > 0.75 || edgePoint.canCoexistWith(type, front) && distance < 0.25) continue;
            callback.accept(OverlapResult.OCCUPIED, location);
            return;
        }
        callback.accept(OverlapResult.VALID, location);
    }

    public static enum OverlapResult {
        VALID,
        OCCUPIED("track_target.occupied"),
        JUNCTION("track_target.no_junctions"),
        NO_TRACK("track_target.invalid");

        public String feedback;

        private OverlapResult() {
        }

        private OverlapResult(String feedback) {
            this.feedback = feedback;
        }
    }
}

