/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.inventory;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public abstract class CapManipulationBehaviourBase<T, S extends CapManipulationBehaviourBase<?, ?>>
extends BlockEntityBehaviour<SmartBlockEntity> {
    protected InterfaceProvider target;
    protected T targetCapability;
    protected Predicate<class_2586> filter;
    protected boolean simulateNext;
    protected boolean bypassSided;
    private boolean findNewNextTick;

    public CapManipulationBehaviourBase(SmartBlockEntity be, InterfaceProvider target) {
        super(be);
        this.setLazyTickRate(5);
        this.target = target;
        this.targetCapability = null;
        this.simulateNext = false;
        this.bypassSided = false;
        this.filter = Predicates.alwaysTrue();
    }

    protected abstract T getCapability(class_1937 var1, class_2338 var2, class_2586 var3, @Nullable class_2350 var4);

    @Override
    public void initialize() {
        super.initialize();
        this.findNewNextTick = true;
    }

    @Override
    public void onNeighborChanged(class_2338 neighborPos) {
        if (this.getTarget().getConnectedPos().equals((Object)neighborPos)) {
            this.onHandlerInvalidated();
        }
    }

    public S bypassSidedness() {
        this.bypassSided = true;
        return (S)this;
    }

    public S simulate() {
        this.simulateNext = true;
        return (S)this;
    }

    public S withFilter(Predicate<class_2586> filter) {
        this.filter = filter;
        return (S)this;
    }

    public boolean hasInventory() {
        return this.targetCapability != null;
    }

    @Nullable
    public T getInventory() {
        return this.targetCapability;
    }

    public BlockFace getTarget() {
        return this.target.getTarget(this.getWorld(), this.blockEntity.method_11016(), this.blockEntity.method_11010());
    }

    protected boolean onHandlerInvalidated() {
        if (this.targetCapability == null) {
            return false;
        }
        this.findNewNextTick = true;
        this.targetCapability = null;
        return true;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.targetCapability == null) {
            this.findNewCapability();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.findNewNextTick || this.getWorld().method_8510() % 64L == 0L) {
            this.findNewNextTick = false;
            this.findNewCapability();
        }
    }

    public int getAmountFromFilter() {
        int amount = -1;
        ServerFilteringBehaviour filter = this.blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        if (filter != null && !filter.anyAmount()) {
            amount = filter.getAmount();
        }
        return amount;
    }

    public ItemHelper.ExtractionCountMode getModeFromFilter() {
        ItemHelper.ExtractionCountMode mode = ItemHelper.ExtractionCountMode.UPTO;
        ServerFilteringBehaviour filter = this.blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        if (filter != null && !filter.upTo) {
            mode = ItemHelper.ExtractionCountMode.EXACTLY;
        }
        return mode;
    }

    public void findNewCapability() {
        class_1937 world = this.getWorld();
        BlockFace targetBlockFace = this.getTarget().getOpposite();
        class_2338 pos = targetBlockFace.getPos();
        this.targetCapability = null;
        if (!world.method_8477(pos)) {
            return;
        }
        class_2586 invBE = world.method_8321(pos);
        if (!this.filter.test((Object)invBE)) {
            return;
        }
        this.targetCapability = this.getCapability(world, pos, invBE, this.bypassSided ? null : targetBlockFace.getFace());
    }

    @FunctionalInterface
    public static interface InterfaceProvider {
        public static InterfaceProvider towardBlockFacing() {
            return (w, p, s) -> new BlockFace(p, s.method_28498((class_2769)class_2741.field_12525) ? (class_2350)s.method_11654((class_2769)class_2741.field_12525) : (class_2350)s.method_11654((class_2769)class_2741.field_12481));
        }

        public static InterfaceProvider oppositeOfBlockFacing() {
            return (w, p, s) -> new BlockFace(p, (s.method_28498((class_2769)class_2741.field_12525) ? (class_2350)s.method_11654((class_2769)class_2741.field_12525) : (class_2350)s.method_11654((class_2769)class_2741.field_12481)).method_10153());
        }

        public BlockFace getTarget(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

