/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.debugInfo;

import com.google.common.collect.ImmutableMap;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.Create;
import com.zurrtum.create.infrastructure.debugInfo.element.DebugInfoSection;
import com.zurrtum.create.infrastructure.debugInfo.element.InfoElement;
import com.zurrtum.create.infrastructure.debugInfo.element.InfoEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_6396;
import org.jetbrains.annotations.Nullable;

public class DebugInformation {
    private static final List<DebugInfoSection> client = new ArrayList<DebugInfoSection>();
    private static final List<DebugInfoSection> server = new ArrayList<DebugInfoSection>();
    private static final ImmutableMap<String, String> mcSystemInfo = (ImmutableMap)class_156.method_656(() -> {
        class_6396 systemReport = new class_6396();
        return ImmutableMap.copyOf((Map)systemReport.field_33858);
    });

    public static void registerClientInfo(DebugInfoSection section) {
        client.add(section);
    }

    public static void registerServerInfo(DebugInfoSection section) {
        server.add(section);
    }

    public static void registerBothInfo(DebugInfoSection section) {
        DebugInformation.registerClientInfo(section);
        DebugInformation.registerServerInfo(section);
    }

    public static List<DebugInfoSection> getClientInfo() {
        return client;
    }

    public static List<DebugInfoSection> getServerInfo() {
        return server;
    }

    public static String getVersionOfMod(String id) {
        return FabricLoader.getInstance().getModContainer(id).map(mod -> mod.getMetadata().getVersion().toString()).orElse("None");
    }

    public static Collection<InfoElement> listAllOtherMods() {
        ArrayList<InfoElement> mods = new ArrayList<InfoElement>();
        FabricLoader.getInstance().getAllMods().forEach(mod -> {
            ModMetadata meta = mod.getMetadata();
            String id = meta.getId();
            if (!(id.equals("create") || id.equals("fabric-api") || id.equals("minecraft") || id.equals("flywheel"))) {
                String name = meta.getName();
                String version = meta.getVersion().toString();
                mods.add(new InfoEntry(name, version));
            }
        });
        return mods;
    }

    public static Collection<InfoElement> listAllGraphicsCards() {
        ArrayList<InfoElement> cards = new ArrayList<InfoElement>();
        for (int i = 0; i < 10; ++i) {
            String name = DebugInformation.getMcSystemInfo("Graphics card #" + i + " name");
            String vendor = DebugInformation.getMcSystemInfo("Graphics card #" + i + " vendor");
            String vram = DebugInformation.getMcSystemInfo("Graphics card #" + i + " VRAM (MB)");
            if (name == null || vendor == null || vram == null) break;
            String key = "Graphics card #" + i;
            String value = String.format("%s (%s); %s MB of VRAM", name, vendor, vram);
            cards.add(new InfoEntry(key, value));
        }
        return cards.isEmpty() ? List.of(new InfoEntry("Graphics cards", "none")) : cards;
    }

    public static String getTotalRam() {
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long usedMemory = totalMemory - availableMemory;
        return String.format("%s bytes (%s MiB) / %s bytes (%s MiB)", usedMemory, usedMemory / 0x100000L, totalMemory, totalMemory / 0x100000L);
    }

    public static String getCpuInfo() {
        String name = DebugInformation.tryTrim(DebugInformation.getMcSystemInfo("Processor Name"));
        String freq = DebugInformation.getMcSystemInfo("Frequency (GHz)");
        String sockets = DebugInformation.getMcSystemInfo("Number of physical packages");
        String cores = DebugInformation.getMcSystemInfo("Number of physical CPUs");
        String threads = DebugInformation.getMcSystemInfo("Number of logical CPUs");
        return String.format("%s @ %s GHz; %s cores / %s threads on %s socket(s)", name, freq, cores, threads, sockets);
    }

    @Nullable
    public static String getMcSystemInfo(String key) {
        return (String)mcSystemInfo.get((Object)key);
    }

    public static String getIndent(int depth) {
        return Stream.generate(() -> "\t").limit(depth).collect(Collectors.joining());
    }

    @Nullable
    public static String tryTrim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    static {
        DebugInfoSection.builder("Create").put("Mod Version", Create.VERSION).put("Ponder Version", DebugInformation.getVersionOfMod("ponder")).put("NeoForge Version", DebugInformation.getVersionOfMod("neoforge")).put("Minecraft Version", class_155.method_16673().comp_4025()).buildTo(DebugInformation::registerBothInfo);
        AllClientHandle.INSTANCE.buildDebugInfo();
        DebugInfoSection.builder("System Information").put("Operating System", class_6396.field_33855).put("Java Version", class_6396.field_33856).put("JVM Flags", DebugInformation.getMcSystemInfo("JVM Flags")).put("Memory", () -> DebugInformation.getMcSystemInfo("Memory")).put("Total Memory", DebugInformation.getTotalRam()).put("CPU", DebugInformation.getCpuInfo()).putAll(DebugInformation.listAllGraphicsCards()).buildTo(DebugInformation::registerBothInfo);
        DebugInfoSection.builder("Other Mods").putAll(DebugInformation.listAllOtherMods()).buildTo(DebugInformation::registerBothInfo);
    }
}

