/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.google.common.collect.MapMaker;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import com.zurrtum.create.infrastructure.transfer.FluidInventorySlotWrapper;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorage;
import com.zurrtum.create.infrastructure.transfer.SidedFluidInventoryStorageImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class FluidInventoryStorageImpl
extends CombinedStorage<FluidVariant, SingleSlotStorage<FluidVariant>>
implements FluidInventoryStorage {
    private static final Map<FluidInventory, FluidInventoryStorageImpl> WRAPPERS = new MapMaker().weakValues().makeMap();
    final FluidInventory inventory;
    final List<FluidInventorySlotWrapper> backingList;
    final MarkDirtyParticipant markDirtyParticipant = new MarkDirtyParticipant();

    public static FluidInventoryStorage of(FluidInventory inventory) {
        FluidInventoryStorageImpl storage = WRAPPERS.computeIfAbsent(inventory, FluidInventoryStorageImpl::new);
        storage.resizeSlotList();
        return storage;
    }

    public static FluidInventoryStorage of(FluidInventory inventory, @Nullable class_2350 direction) {
        FluidInventoryStorageImpl storage = WRAPPERS.computeIfAbsent(inventory, FluidInventoryStorageImpl::new);
        storage.resizeSlotList();
        return storage.getSidedWrapper(direction);
    }

    public FluidInventoryStorageImpl(FluidInventory inventory) {
        super(Collections.emptyList());
        this.inventory = inventory;
        this.backingList = new ArrayList<FluidInventorySlotWrapper>();
    }

    @Override
    public List<SingleSlotStorage<FluidVariant>> getSlots() {
        return this.parts;
    }

    private void resizeSlotList() {
        int inventorySize = this.inventory.size();
        if (inventorySize != this.parts.size()) {
            while (this.backingList.size() < inventorySize) {
                this.backingList.add(new FluidInventorySlotWrapper(this, this.backingList.size()));
            }
            this.parts = Collections.unmodifiableList(this.backingList.subList(0, inventorySize));
        }
    }

    private FluidInventoryStorage getSidedWrapper(@Nullable class_2350 direction) {
        if (this.inventory instanceof SidedFluidInventory && direction != null) {
            return new SidedFluidInventoryStorageImpl(this, direction);
        }
        return this;
    }

    public String toString() {
        return "FluidInventoryStorage[" + FluidInventoryStorage.toString(this.inventory) + "]";
    }

    class MarkDirtyParticipant
    extends SnapshotParticipant<Boolean> {
        MarkDirtyParticipant() {
        }

        protected Boolean createSnapshot() {
            return Boolean.TRUE;
        }

        protected void readSnapshot(Boolean snapshot) {
        }

        protected void onFinalCommit() {
            FluidInventoryStorageImpl.this.inventory.markDirty();
        }
    }
}

