/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import com.zurrtum.create.infrastructure.transfer.FluidInventorySlotWrapper;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;

public class SidedFluidInventorySlotWrapper
implements SingleSlotStorage<FluidVariant> {
    private final FluidInventorySlotWrapper slotWrapper;
    private final SidedFluidInventory sidedInventory;
    private final class_2350 direction;

    SidedFluidInventorySlotWrapper(FluidInventorySlotWrapper slotWrapper, SidedFluidInventory sidedInventory, class_2350 direction) {
        this.slotWrapper = slotWrapper;
        this.sidedInventory = sidedInventory;
        this.direction = direction;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.sidedInventory.canInsert(this.slotWrapper.slot, FluidInventoryStorage.getCachedStack(resource), this.direction)) {
            return 0L;
        }
        return this.slotWrapper.insert(resource, maxAmount, transaction);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.sidedInventory.canExtract(this.slotWrapper.slot, FluidInventoryStorage.getCachedStack(resource), this.direction)) {
            return 0L;
        }
        return this.slotWrapper.extract(resource, maxAmount, transaction);
    }

    public boolean isResourceBlank() {
        return this.slotWrapper.isResourceBlank();
    }

    public FluidVariant getResource() {
        return this.slotWrapper.getResource();
    }

    public long getAmount() {
        return this.slotWrapper.getAmount();
    }

    public long getCapacity() {
        return this.slotWrapper.getCapacity();
    }

    public StorageView<FluidVariant> getUnderlyingView() {
        return this.slotWrapper.getUnderlyingView();
    }

    public String toString() {
        return "SidedInventorySlotWrapper[%s#%d/%s]".formatted(FluidInventoryStorage.toString(this.sidedInventory), this.slotWrapper.slot, this.direction.name());
    }
}

